/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.identifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;

public abstract class AbstractIdentificationResult
implements IIdentificationResult {
    private List<IIdentificationTarget> entries = new ArrayList<IIdentificationTarget>();

    @Override
    public void add(IIdentificationTarget entry) {
        this.entries.add(entry);
    }

    @Override
    public IIdentificationTarget getBestHit() {
        float actMQ = Float.MIN_VALUE;
        IIdentificationTarget actualEntry = null;
        for (IIdentificationTarget entry : this.entries) {
            IComparisonResult comparisonResult;
            if (entry == null || (comparisonResult = entry.getComparisonResult()) == null || !(comparisonResult.getMatchFactor() >= actMQ)) continue;
            actualEntry = entry;
            actMQ = comparisonResult.getMatchFactor();
        }
        return actualEntry;
    }

    @Override
    public void remove(IIdentificationTarget entry) {
        this.entries.remove(entry);
    }

    @Override
    public void removeAll() {
        this.entries.clear();
    }

    @Override
    public Collection<IIdentificationTarget> getIdentificationEntries() {
        return this.entries;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        IIdentificationResult otherResult = (IIdentificationResult)other;
        return this.hashCode() == otherResult.hashCode();
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("size=" + this.entries.size());
        builder.append("]");
        return builder.toString();
    }
}

