/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.TargetTransferSupport;
import org.eclipse.chemclipse.model.updates.IChromatogramSelectionUpdateListener;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.RetentionTimeValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.EditorUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ChromatogramSourceCombo;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PeakTargetTransferUI
extends Composite
implements IChromatogramSelectionUpdateListener {
    private static final Logger logger = Logger.getLogger(PeakTargetTransferUI.class);
    private static final String DESCRIPTION = "Transfer Target(s)";
    private static final String TYPE_PEAKS = "Peaks";
    private static final String TYPE_SCANS = "Scans";
    private static final String[] TYPE_ITEMS = new String[]{"Peaks", "Scans"};
    private Label labelSource;
    private ChromatogramSourceCombo chromatogramSourceCombo;
    private ComboViewer comboViewerSink;
    private Combo comboType;
    private Text textTimeDelta;
    private Button checkBoxTransfer;
    private Button buttonExecute;
    private IChromatogramSelection chromatogramSelectionSource;
    private ChromatogramDataSupport chromatogramDataSupport = new ChromatogramDataSupport();
    private EditorUpdateSupport editorUpdateSupport = new EditorUpdateSupport();
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public PeakTargetTransferUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void update(IChromatogramSelection chromatogramSelectionSource) {
        this.chromatogramSelectionSource = chromatogramSelectionSource;
        this.updateInput();
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        composite.setLayout((Layout)gridLayout);
        this.createLabelInfo(composite, "Chromatogram:");
        this.labelSource = this.createLabelSource(composite);
        this.createLabelInfo(composite, "Destination:");
        this.chromatogramSourceCombo = this.createChromatogramSourceCombo(composite);
        this.createLabelInfo(composite, "Target:");
        this.comboViewerSink = this.createComboViewerSink(composite);
        this.createLabelInfo(composite, "Type:");
        this.comboType = this.createTypeCombo(composite);
        this.createLabelInfo(composite, "Options:");
        this.textTimeDelta = this.createTextTargetDelta(composite);
        this.checkBoxTransfer = this.createCheckBoxTransferTargets(composite);
        this.buttonExecute = this.createButtonExecute(composite);
        this.updateInput();
    }

    private void createLabelInfo(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    private Label createLabelSource(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText("");
        return label;
    }

    private ChromatogramSourceCombo createChromatogramSourceCombo(Composite parent) {
        ChromatogramSourceCombo chromatogramSourceCombo = new ChromatogramSourceCombo(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        chromatogramSourceCombo.setLayoutData(gridData);
        Combo combo = chromatogramSourceCombo.getCombo();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeakTargetTransferUI.this.updateInput();
            }
        });
        return chromatogramSourceCombo;
    }

    private ComboViewer createComboViewerSink(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)new ListContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IChromatogramSelection) {
                    IChromatogramSelection chromatogramSelection = (IChromatogramSelection)element;
                    String name = chromatogramSelection.getChromatogram().getName();
                    String type = ChromatogramDataSupport.getChromatogramType(chromatogramSelection);
                    return PeakTargetTransferUI.this.getChromatogramLabel(name, type, "External");
                }
                if (element instanceof IChromatogram) {
                    IChromatogram chromatogram = (IChromatogram)element;
                    String name = chromatogram.getName();
                    String type = ChromatogramDataSupport.getChromatogramType(chromatogram);
                    return PeakTargetTransferUI.this.getChromatogramLabel(name, type, "Internal");
                }
                return null;
            }
        });
        combo.setToolTipText("Select a sink chromatogram.");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeakTargetTransferUI.this.updateWidgets();
            }
        });
        return comboViewer;
    }

    private String getChromatogramLabel(String name, String type, String defaultName) {
        String label = name == null || "".equals(name.trim()) ? String.valueOf(defaultName) + type : String.valueOf(name) + " " + type;
        return label;
    }

    private Combo createTypeCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        combo.setItems(TYPE_ITEMS);
        combo.select(0);
        combo.setToolTipText("Select a type (Peaks or Scans) to be transfered.");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeakTargetTransferUI.this.updateWidgets();
            }
        });
        return combo;
    }

    private Text createTextTargetDelta(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText(Double.toString(this.preferenceStore.getDouble("chromatogramTransferDeltaRetentionTime")));
        text.setToolTipText("Delta retention time in minutes.");
        text.setLayoutData((Object)new GridData(768));
        final RetentionTimeValidator retentionTimeValidator = new RetentionTimeValidator();
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
                if (PeakTargetTransferUI.this.validate(retentionTimeValidator, controlDecoration, text)) {
                    PeakTargetTransferUI.this.preferenceStore.setValue("chromatogramTransferDeltaRetentionTime", retentionTimeValidator.getRetentionTime());
                }
            }
        });
        return text;
    }

    private Button createCheckBoxTransferTargets(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Best Target Only");
        button.setSelection(this.preferenceStore.getBoolean("chromatogramTransferBestTargetOnly"));
        button.setToolTipText("Transfer only the best matching target.");
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeakTargetTransferUI.this.preferenceStore.setValue("chromatogramTransferBestTargetOnly", button.getSelection());
            }
        });
        return button;
    }

    private Button createButtonExecute(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Transfer Targets");
        button.setToolTipText("Transfer the targets from the source to the sink chromatogram.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = PeakTargetTransferUI.this.comboViewerSink.getStructuredSelection().getFirstElement();
                IChromatogramSelection<?, ?> chromatogramSelectionSink = PeakTargetTransferUI.this.chromatogramDataSupport.getChromatogramSelection(object);
                PeakTargetTransferUI.this.transferTargets(PeakTargetTransferUI.this.chromatogramSelectionSource, chromatogramSelectionSink, e.display.getActiveShell());
            }
        });
        return button;
    }

    private void updateInput() {
        this.labelSource.setText(ChromatogramDataSupport.getChromatogramEditorLabel(this.chromatogramSelectionSource));
        if (this.chromatogramSourceCombo.isSourceReferences() && this.chromatogramSelectionSource != null) {
            this.comboViewerSink.setInput((Object)this.chromatogramSelectionSource.getChromatogram().getReferencedChromatograms());
        } else if (this.chromatogramSourceCombo.isSourceEditors()) {
            this.comboViewerSink.setInput(this.getFilteredEditorChromatogramSelections());
        } else {
            this.comboViewerSink.setInput(null);
        }
        this.updateWidgets();
    }

    private void updateWidgets() {
        this.textTimeDelta.setEnabled(false);
        this.checkBoxTransfer.setEnabled(false);
        this.buttonExecute.setEnabled(false);
        this.chromatogramSourceCombo.setEnabled(this.chromatogramSelectionSource != null);
        Object object = this.comboViewerSink.getStructuredSelection().getFirstElement();
        if (object instanceof IChromatogramSelection || object instanceof IChromatogram) {
            this.buttonExecute.setEnabled(true);
            this.checkBoxTransfer.setEnabled(true);
        }
        this.textTimeDelta.setEnabled(this.comboType.getText().equals(TYPE_PEAKS));
    }

    private List<IChromatogramSelection> getFilteredEditorChromatogramSelections() {
        ArrayList<IChromatogramSelection> chromatogramSelections = new ArrayList<IChromatogramSelection>();
        if (this.chromatogramSelectionSource != null) {
            String nameSource = ChromatogramDataSupport.getChromatogramEditorLabel(this.chromatogramSelectionSource);
            for (IChromatogramSelection chromatogramSelectionTarget : this.editorUpdateSupport.getChromatogramSelections()) {
                String nameTarget = ChromatogramDataSupport.getChromatogramEditorLabel(chromatogramSelectionTarget);
                if (nameSource.equals(nameTarget)) continue;
                chromatogramSelections.add(chromatogramSelectionTarget);
            }
        }
        return chromatogramSelections;
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, Text text) {
        IStatus status = validator.validate((Object)text.getText());
        if (status.isOK()) {
            controlDecoration.hide();
            return true;
        }
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText(status.getMessage());
        controlDecoration.show();
        return false;
    }

    private void transferTargets(IChromatogramSelection chromatogramSelectionSource, IChromatogramSelection chromatogramSelectionSink, Shell shell) {
        if (chromatogramSelectionSource != null) {
            if (chromatogramSelectionSink != null && chromatogramSelectionSink != chromatogramSelectionSource) {
                MessageBox messageBox = new MessageBox(shell, 196);
                messageBox.setText(DESCRIPTION);
                messageBox.setMessage("Would you like to transfer the selected target(s) to chromatogram: " + ChromatogramDataSupport.getChromatogramEditorLabel(chromatogramSelectionSink) + "?");
                if (messageBox.open() == 64) {
                    if (this.comboType.getText().equals(TYPE_PEAKS)) {
                        this.transferPeakTargets(chromatogramSelectionSource, chromatogramSelectionSink, shell);
                    } else {
                        this.transferScanTargets(chromatogramSelectionSource, chromatogramSelectionSink, shell);
                    }
                }
            } else {
                this.showWarnMessage(shell, "It's not possible to transfer targets to the same chromatogram.");
            }
        } else {
            this.showWarnMessage(shell, "A source chromatogram is not available.");
        }
    }

    private void transferPeakTargets(IChromatogramSelection chromatogramSelectionSource, IChromatogramSelection chromatogramSelectionSink, Shell shell) {
        boolean useBestTargetOnly;
        int retentionTimeDelta;
        List peaksSink;
        TargetTransferSupport targetTransferSupport = new TargetTransferSupport();
        List peaksSource = ChromatogramDataSupport.getPeaks(chromatogramSelectionSource, true);
        String message = targetTransferSupport.transferPeakTargets(peaksSource, peaksSink = ChromatogramDataSupport.getPeaks(chromatogramSelectionSink, false), retentionTimeDelta = (int)(this.preferenceStore.getDouble("chromatogramTransferDeltaRetentionTime") * 60000.0), useBestTargetOnly = this.preferenceStore.getBoolean("chromatogramTransferBestTargetOnly"));
        if (message != null) {
            this.showWarnMessage(shell, message);
        } else {
            MessageDialog.openInformation((Shell)shell, (String)DESCRIPTION, (String)"The peak target(s) have been transfered successfully.");
        }
    }

    private void transferScanTargets(IChromatogramSelection chromatogramSelectionSource, IChromatogramSelection chromatogramSelectionSink, Shell shell) {
        boolean useBestTargetOnly;
        IChromatogram chromatogramSink;
        TargetTransferSupport targetTransferSupport = new TargetTransferSupport();
        List<IScan> scansSource = ChromatogramDataSupport.getIdentifiedScans((IChromatogram<? extends IPeak>)chromatogramSelectionSource.getChromatogram(), chromatogramSelectionSource);
        String message = targetTransferSupport.transferScanTargets(scansSource, chromatogramSink = chromatogramSelectionSink.getChromatogram(), useBestTargetOnly = this.preferenceStore.getBoolean("chromatogramTransferBestTargetOnly"));
        if (message != null) {
            this.showWarnMessage(shell, message);
        } else {
            MessageDialog.openInformation((Shell)shell, (String)DESCRIPTION, (String)"The scan target(s) have been transfered successfully.");
        }
    }

    private void showWarnMessage(Shell shell, String message) {
        logger.warn((Object)message);
        MessageDialog.openWarning((Shell)shell, (String)DESCRIPTION, (String)message);
    }
}

