/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.Collection;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilterSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.MassSpectrumFilter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.IUpdateListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ScanFilterUI
extends Composite {
    private static final Logger logger = Logger.getLogger(ScanFilterUI.class);
    private ComboViewer comboViewer;
    private Button button;
    private IScan scan = null;
    private IUpdateListener updateListener = null;

    public ScanFilterUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setInput(IScan scan) {
        this.scan = scan;
        boolean enabled = scan instanceof IScanMSD;
        this.comboViewer.getCombo().setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setUpdateListener(IUpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.comboViewer = this.createComboViewer(composite);
        this.button = this.createButton(composite);
        IMassSpectrumFilterSupport massSpectrumFilterSupport = MassSpectrumFilter.getMassSpectrumFilterSupport();
        Collection suppliers = massSpectrumFilterSupport.getSuppliers();
        this.comboViewer.setInput((Object)suppliers);
        if (suppliers.size() > 0) {
            this.comboViewer.getCombo().select(0);
        }
    }

    private ComboViewer createComboViewer(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IMassSpectrumFilterSupplier) {
                    IMassSpectrumFilterSupplier supplier = (IMassSpectrumFilterSupplier)element;
                    return supplier.getFilterName();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a scan filter.");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 200;
        combo.setLayoutData((Object)gridData);
        return comboViewer;
    }

    private Button createButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Filter the currently selected scan.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = ScanFilterUI.this.comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof IMassSpectrumFilterSupplier) {
                    IMassSpectrumFilterSupplier supplier = (IMassSpectrumFilterSupplier)object;
                    if (ScanFilterUI.this.scan instanceof IScanMSD) {
                        IScanMSD scanMSD = (IScanMSD)ScanFilterUI.this.scan;
                        IScanMSD optimizedMassSpectrum = scanMSD.getOptimizedMassSpectrum();
                        if (optimizedMassSpectrum == null) {
                            try {
                                optimizedMassSpectrum = scanMSD.makeDeepCopy();
                                scanMSD.setOptimizedMassSpectrum(optimizedMassSpectrum);
                            }
                            catch (CloneNotSupportedException e1) {
                                logger.warn((Object)e1);
                            }
                        }
                        if (optimizedMassSpectrum != null) {
                            optimizedMassSpectrum.getTargets().clear();
                            MassSpectrumFilter.applyFilter((IScanMSD)optimizedMassSpectrum, (String)supplier.getId(), (IProgressMonitor)new NullProgressMonitor());
                            ScanFilterUI.this.fireUpdate();
                        }
                    }
                }
            }
        });
        return button;
    }

    private void fireUpdate() {
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }
}

