/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.PeakScanListEditingSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.PeakScanListFilter;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.PeakScanListLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.PeakScanListTableComparator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class PeakScanListUI
extends ExtendedTableViewer {
    private final String[] titles = PeakScanListLabelProvider.TITLES;
    private final int[] bounds = PeakScanListLabelProvider.BOUNDS;
    private final PeakScanListLabelProvider labelProvider = new PeakScanListLabelProvider();
    private final PeakScanListTableComparator tableComparator = new PeakScanListTableComparator();
    private final PeakScanListFilter listFilter = new PeakScanListFilter();

    public PeakScanListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void setInput(IChromatogramSelection<?, ?> chromatogramSelection, boolean showPeaks, boolean showPeaksInRange, boolean showScans, boolean showScansInRange) {
        if (chromatogramSelection != null) {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            double chromatogramPeakArea = chromatogram.getPeakIntegratedArea();
            this.labelProvider.setChromatogramPeakArea(chromatogramPeakArea);
            this.tableComparator.setChromatogramPeakArea(chromatogramPeakArea);
            ArrayList<Object> input = new ArrayList<Object>();
            if (showPeaks) {
                input.addAll(ChromatogramDataSupport.getPeaks(chromatogramSelection, showPeaksInRange));
            }
            if (showScans) {
                input.addAll(ChromatogramDataSupport.getIdentifiedScans(chromatogramSelection, showScansInRange));
            }
            super.setInput(input);
        } else {
            this.clear();
        }
    }

    public void setInput(IPeaks<?> peaks) {
        this.labelProvider.setChromatogramPeakArea(0.0);
        this.tableComparator.setChromatogramPeakArea(0.0);
        super.setInput((Object)peaks.getPeaks());
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.listFilter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    public void clear() {
        super.setInput(null);
    }

    private void createColumns() {
        this.createColumns(this.titles, this.bounds);
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator((ViewerComparator)this.tableComparator);
        this.setFilters(new ViewerFilter[]{this.listFilter});
        this.setEditingSupport();
    }

    private void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if ("Active for Analysis".equals(label)) {
                tableViewerColumn.setEditingSupport((EditingSupport)new PeakScanListEditingSupport(this, label));
            } else if ("Classifier".equals(label)) {
                tableViewerColumn.setEditingSupport((EditingSupport)new PeakScanListEditingSupport(this, label));
            } else if ("Name".equals(label)) {
                tableViewerColumn.setEditingSupport((EditingSupport)new PeakScanListEditingSupport(this, label));
            }
            ++i;
        }
    }
}

