/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IMarkedSignal;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.ChromatogramHeatmapData;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.ChromatogramHeatmapSupport;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelength;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelengths;
import org.eclipse.chemclipse.wsd.model.core.support.MarkedWavelength;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.widgets.datadefinition.IManualValueChangeListener;
import org.eclipse.nebula.visualization.widgets.datadefinition.IPrimaryArrayWrapper;
import org.eclipse.nebula.visualization.widgets.figures.IntensityGraphFigure;
import org.eclipse.nebula.visualization.widgets.figures.ScaledSliderFigure;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class HeatmapUI {
    private XYGraph m_plot;
    private IntensityGraphFigure m_heatmap;
    private Figure m_container;
    private LightweightSystem m_lws;
    private Trace trace;
    private ScaledSliderFigure slider;
    private List<IMarkedSignal> signals;
    private IChromatogramSelection chromatogramSelection;
    private ChromatogramHeatmapData chromatogramHeatmap;
    private Label selectedWavelengthLabel;
    private ChromatogramHeatmapSupport chromatogramHeatmapSupport = new ChromatogramHeatmapSupport();
    private Composite parent;

    public HeatmapUI(Composite parent) {
        this.signals = new ArrayList<IMarkedSignal>();
        this.parent = parent;
    }

    public void setChromatogramSelection(IChromatogramSelection chromatogramSelection) {
        Optional<ChromatogramHeatmapData> heatmap = this.chromatogramHeatmapSupport.getHeatmap(chromatogramSelection.getChromatogram());
        this.chromatogramSelection = chromatogramSelection;
        this.signals.clear();
        if (chromatogramSelection instanceof IChromatogramSelectionWSD) {
            this.initWSD();
            if (heatmap.isPresent()) {
                this.chromatogramHeatmap = heatmap.get();
                this.setHeatMap(this.chromatogramHeatmap);
            }
            IChromatogramSelectionWSD chromatogramSelectionWSD = (IChromatogramSelectionWSD)chromatogramSelection;
            double selectedSliderValue = this.setSlider(chromatogramSelectionWSD);
            this.setSelectedWavelength(selectedSliderValue);
        } else if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            this.initMSD();
            if (heatmap.isPresent()) {
                this.chromatogramHeatmap = heatmap.get();
                this.setHeatMap(this.chromatogramHeatmap);
            }
        } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
            this.initCSD();
            if (heatmap.isPresent()) {
                this.chromatogramHeatmap = heatmap.get();
                this.setHeatMap(this.chromatogramHeatmap);
            }
        }
    }

    private void initWSD() {
        this.disposeChildren(this.parent);
        Composite composite = new Composite(this.parent, 2048);
        composite.setLayout((Layout)new GridLayout(2, false));
        Canvas cavensSlider = new Canvas(composite, 0);
        cavensSlider.setLayoutData((Object)new GridData(1040));
        this.slider(cavensSlider);
        Canvas cavensHeatMap = new Canvas(composite, 0);
        cavensHeatMap.setLayoutData((Object)new GridData(1808));
        this.createChart(cavensHeatMap);
        this.selectedWavelengthLabel = new Label(composite, 0);
        GridData gridData = new GridData(3);
        gridData.horizontalSpan = 2;
        this.selectedWavelengthLabel.setLayoutData((Object)gridData);
        this.parent.layout(true, true);
        this.parent.redraw();
    }

    private void initMSD() {
        this.disposeChildren(this.parent);
        Composite composite = new Composite(this.parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, false));
        Canvas cavensHeatMap = new Canvas(composite, 0);
        this.createChart(cavensHeatMap);
        this.parent.layout(true, true);
        this.parent.redraw();
    }

    private void initCSD() {
        this.disposeChildren(this.parent);
        Composite composite = new Composite(this.parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, false));
        Canvas cavensHeatMap = new Canvas(composite, 0);
        this.createChart(cavensHeatMap);
        this.parent.layout(true, true);
        this.parent.redraw();
    }

    private void disposeChildren(Composite composite) {
        Arrays.stream(composite.getChildren()).forEach(control -> control.dispose());
    }

    private void setHeatMap(ChromatogramHeatmapData chromatogramHeatmap) {
        Range axisRangeWidth = chromatogramHeatmap.getAxisRangeWidth();
        Range axisRangeHight = chromatogramHeatmap.getAxisRangeHight();
        double maxIntensity = chromatogramHeatmap.getMaximum();
        double minIntensity = chromatogramHeatmap.getMinimum();
        int dataWidth = chromatogramHeatmap.getDataWidth();
        int dataHeight = chromatogramHeatmap.getDataHeight();
        IPrimaryArrayWrapper data = chromatogramHeatmap.getArrayWrapper();
        this.m_plot.getPrimaryXAxis().setRange(axisRangeWidth);
        this.m_plot.getPrimaryYAxis().setRange(axisRangeHight);
        this.m_heatmap.getXAxis().setRange(axisRangeWidth);
        this.m_heatmap.getYAxis().setRange(axisRangeHight);
        this.m_heatmap.setMax(maxIntensity);
        this.m_heatmap.setMin(minIntensity);
        this.m_heatmap.setDataHeight(dataHeight);
        this.m_heatmap.setDataWidth(dataWidth);
        this.m_heatmap.setDataArray(data);
        this.m_heatmap.repaint();
    }

    private int setSlider(IChromatogramSelectionWSD chromatogramSelectionWSD) {
        chromatogramSelectionWSD.getChromatogramWSD().getWavelengths().stream().sorted((w1, w2) -> Double.compare(w1, w2)).forEach(wavelength -> {
            boolean bl = this.signals.add((IMarkedSignal)new MarkedWavelength(wavelength.doubleValue()));
        });
        IMarkedWavelengths markedWavelenghts = chromatogramSelectionWSD.getSelectedWavelengths();
        if (markedWavelenghts.isEmpty()) {
            markedWavelenghts.add((Object)((IMarkedWavelength)this.signals.get(0)));
        }
        IMarkedWavelength selectedWawelength = (IMarkedWavelength)markedWavelenghts.stream().findFirst().get();
        int selectedSliderValue = 0;
        double selectedWavelength = selectedWawelength.getWavelength();
        int i = 0;
        while (i < this.signals.size()) {
            if (((IMarkedWavelength)this.signals.get(i)).getWavelength() == selectedWavelength) {
                selectedSliderValue = i + 1;
            }
            ++i;
        }
        if (this.signals.size() > 1) {
            this.slider.setEnabled(true);
            this.slider.setRange(1.0, (double)this.signals.size());
            this.slider.setStepIncrement(1.0);
            this.slider.repaint();
            this.slider.setValue((double)selectedSliderValue);
            this.m_container.setEnabled(true);
        } else {
            this.slider.setEnabled(false);
            this.m_container.setEnabled(false);
        }
        return selectedSliderValue;
    }

    private void slider(Canvas cavens) {
        LightweightSystem lws = new LightweightSystem(cavens);
        this.slider = new ScaledSliderFigure();
        this.slider.setFillBackgroundColor(ColorConstants.lightGray);
        this.slider.setFillColor(ColorConstants.lightGray);
        this.slider.setShowHi(false);
        this.slider.setShowHihi(false);
        this.slider.setShowLo(false);
        this.slider.setShowLolo(false);
        this.slider.setShowMarkers(false);
        this.slider.setShowScale(false);
        this.slider.setThumbColor(ColorConstants.lightGray);
        this.slider.addManualValueChangeListener(new IManualValueChangeListener(){

            public void manualValueChanged(double selectedSliderValue) {
                if (HeatmapUI.this.chromatogramSelection instanceof IChromatogramSelectionWSD) {
                    HeatmapUI.this.setSelectedWavelength(selectedSliderValue);
                }
            }
        });
        lws.setContents((IFigure)this.slider);
    }

    private void createChart(final Canvas cavens) {
        this.m_plot = new XYGraph();
        this.m_plot.setShowLegend(false);
        this.m_plot.setTransparent(true);
        this.m_plot.getPrimaryXAxis().setTitle(null);
        this.m_plot.getPrimaryXAxis().setShowMinLabel(false);
        this.m_plot.getPrimaryXAxis().setShowMaxLabel(false);
        this.m_plot.getPrimaryYAxis().setTitle(null);
        this.m_plot.getPrimaryXAxis().setMinorTicksVisible(false);
        this.m_plot.getPrimaryYAxis().setMinorTicksVisible(false);
        this.m_plot.getPrimaryYAxis().setScaleLineVisible(false);
        this.m_plot.setShowLegend(false);
        this.m_plot.setTransparent(true);
        this.m_plot.getPrimaryXAxis().setMinorTicksVisible(false);
        this.m_plot.getPrimaryXAxis().setShowMajorGrid(false);
        this.m_plot.getPrimaryYAxis().setMinorTicksVisible(false);
        this.m_plot.getPrimaryYAxis().setShowMajorGrid(false);
        this.m_heatmap = new IntensityGraphFigure(true);
        this.m_heatmap.getXAxis().setTitle(null);
        this.m_heatmap.getYAxis().setTitle(null);
        this.m_heatmap.getXAxis().setMinorTicksVisible(false);
        this.m_heatmap.getYAxis().setMinorTicksVisible(false);
        this.m_heatmap.setShowRamp(false);
        this.m_heatmap.getXAxis().setMinorTicksVisible(false);
        this.m_heatmap.getXAxis().setShowMajorGrid(false);
        this.m_heatmap.getXAxis().setShowMinLabel(false);
        this.m_heatmap.getXAxis().setShowMaxLabel(false);
        this.m_heatmap.getYAxis().setMinorTicksVisible(false);
        this.m_heatmap.getYAxis().setShowMajorGrid(false);
        this.m_heatmap.getYAxis().setScaleLineVisible(false);
        this.m_heatmap.setColorMap(new ColorMap(ColorMap.PredefinedColorMap.JET, true, true));
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        this.trace = new Trace("Trace1-XY Plot", this.m_plot.getPrimaryXAxis(), this.m_plot.getPrimaryYAxis(), (IDataProvider)traceDataProvider);
        this.trace.setLineWidth(5);
        this.trace.setTraceColor(ColorConstants.orange);
        this.trace.setPointStyle(Trace.PointStyle.NONE);
        this.m_plot.addTrace(this.trace);
        org.eclipse.swt.graphics.Rectangle client = cavens.getClientArea();
        Rectangle constraint = new Rectangle(0, 0, client.width, client.height);
        this.m_container = new Figure();
        this.m_container.setLayoutManager((LayoutManager)new XYLayout());
        this.m_lws = new LightweightSystem(cavens);
        this.m_lws.setContents((IFigure)this.m_container);
        this.m_lws.getRootFigure().setBackgroundColor(ColorConstants.white);
        this.m_lws.setContents((IFigure)this.m_container);
        cavens.setLayoutData((Object)new GridData(1808));
        cavens.setLayout((Layout)new FillLayout());
        cavens.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                org.eclipse.swt.graphics.Rectangle rect = cavens.getClientArea();
                Rectangle constraint = new Rectangle(0, 0, rect.width, rect.height);
                HeatmapUI.this.m_container.add((IFigure)HeatmapUI.this.m_heatmap, (Object)constraint);
                HeatmapUI.this.m_container.add((IFigure)HeatmapUI.this.m_plot, (Object)constraint);
            }
        });
    }

    private void setSelectedWavelength(double selectedSliderValue) {
        IMarkedWavelength selectedWavelength = (IMarkedWavelength)this.signals.get((int)selectedSliderValue - 1);
        this.createTrace(selectedWavelength.getWavelength());
        this.selectedWavelengthLabel.setText("Selected wavelength " + selectedWavelength.getWavelength() + " nm");
        IChromatogramSelectionWSD chromatogramSelectionWSD = (IChromatogramSelectionWSD)this.chromatogramSelection;
        IMarkedWavelengths selectedWavelengths = chromatogramSelectionWSD.getSelectedWavelengths();
        selectedWavelengths.clear();
        selectedWavelengths.add((Object)selectedWavelength);
        chromatogramSelectionWSD.update(true);
        this.parent.layout(true, true);
        this.parent.redraw();
    }

    private void createTrace(double value) {
        if (this.chromatogramHeatmap != null) {
            CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
            Range axisRangeWidth = this.chromatogramHeatmap.getAxisRangeWidth();
            traceDataProvider.setBufferSize(100);
            traceDataProvider.setCurrentYDataArray(new double[]{value, value});
            traceDataProvider.setCurrentXDataArray(new double[]{axisRangeWidth.getLower(), axisRangeWidth.getUpper()});
            this.trace.setDataProvider((IDataProvider)traceDataProvider);
            this.m_plot.repaint();
        }
    }
}

