/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.ux.extension.ui.provider.ISupplierEditorSupport;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.SequenceFileRunnable;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.SupplierEditorSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageSequences;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.SequenceFilesUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class ExtendedSequenceExplorerUI {
    private static final Logger logger = Logger.getLogger(ExtendedSequenceExplorerUI.class);
    private Composite toolbarSearch;
    private ComboViewer rootFolderComboViewer;
    private ComboViewer subFolderComboViewer;
    private SequenceFilesUI sequenceFilesUI;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private ISupplierEditorSupport supplierEditorSupport = new SupplierEditorSupport(DataType.SEQ);

    @Inject
    public ExtendedSequenceExplorerUI(Composite parent) {
        this.initialize(parent);
    }

    public void setFocus() {
        this.sequenceFilesUI.getTable().setFocus();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setBackground(DisplayUtils.getDisplay().getSystemColor(22));
        this.createToolbarMain(parent);
        this.toolbarSearch = this.createToolbarSearch(parent);
        this.createSequenceSelection(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
        this.adjustSettings();
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createButtonToggleToolbarSearch(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedSequenceExplorerUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the sequence file editor.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageSequences preferencePage1 = new PreferencePageSequences();
                preferencePage1.setTitle("Sequences");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage1));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedSequenceExplorerUI.this.adjustSettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarSearch(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        searchSupportUI.setLayoutData((Object)new GridData(768));
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                ExtendedSequenceExplorerUI.this.sequenceFilesUI.setSearchText(searchText, caseSensitive);
            }
        });
        return searchSupportUI;
    }

    private void createSequenceSelection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.rootFolderComboViewer = this.createRootFolderComboViewer(composite);
        this.createRootFolderButton(composite);
        this.subFolderComboViewer = this.createSubFolderComboViewer(composite);
        this.sequenceFilesUI = this.createSequenceFileList(composite);
        this.createBatchOpenButton(composite);
    }

    private ComboViewer createRootFolderComboViewer(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof File) {
                    File file = (File)element;
                    return file.getName();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a folder.");
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof File) {
                    File file = (File)object;
                    ExtendedSequenceExplorerUI.this.preferenceStore.setValue("sequenceExplorerPathParentFolder", file.getAbsolutePath());
                    if (ExtendedSequenceExplorerUI.this.preferenceStore.getBoolean("sequenceExplorerUseSubfolder")) {
                        List files = ExtendedSequenceExplorerUI.this.getDirectories(file);
                        ExtendedSequenceExplorerUI.this.setSubFolderContent(files);
                    } else {
                        ExtendedSequenceExplorerUI.this.setSequenceListContent(file);
                    }
                }
            }
        });
        return comboViewer;
    }

    private Button createRootFolderButton(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Select the root folder.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(DisplayUtils.getShell((Widget)button));
                directoryDialog.setText("Sequence Folder");
                directoryDialog.setMessage("Select the sequence root folder.");
                directoryDialog.setFilterPath(ExtendedSequenceExplorerUI.this.preferenceStore.getString("sequenceExplorerPathRootFolder"));
                String directory = directoryDialog.open();
                if (directory != null) {
                    List files = ExtendedSequenceExplorerUI.this.getDirectories(new File(directory));
                    ExtendedSequenceExplorerUI.this.preferenceStore.setValue("sequenceExplorerPathRootFolder", directory);
                    ExtendedSequenceExplorerUI.this.setRootFolderContent(files);
                }
            }
        });
        return button;
    }

    private ComboViewer createSubFolderComboViewer(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof File) {
                    File file = (File)element;
                    return file.getName();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a sub folder.");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file;
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof File && (file = (File)object).isDirectory()) {
                    ExtendedSequenceExplorerUI.this.preferenceStore.setValue("sequenceExplorerPathSubFolder", file.getAbsolutePath());
                    ExtendedSequenceExplorerUI.this.setSequenceListContent(file);
                }
            }
        });
        return comboViewer;
    }

    private SequenceFilesUI createSequenceFileList(Composite parent) {
        final SequenceFilesUI sequenceFilesUI = new SequenceFilesUI(parent, 2050);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        Table table = sequenceFilesUI.getTable();
        table.setLayoutData((Object)gridData);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object object = sequenceFilesUI.getStructuredSelection().getFirstElement();
                if (object instanceof File) {
                    File file = (File)object;
                    ExtendedSequenceExplorerUI.this.supplierEditorSupport.openEditor(file, false);
                }
            }
        });
        return sequenceFilesUI;
    }

    private Button createBatchOpenButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Open Sequence(s)");
        button.setToolTipText("Open the selected sequences.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/import.png", "16x16"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices;
                Table table = ExtendedSequenceExplorerUI.this.sequenceFilesUI.getTable();
                int[] nArray = indices = table.getSelectionIndices();
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    Object object = table.getItem(index).getData();
                    if (object instanceof File) {
                        File file = (File)object;
                        ExtendedSequenceExplorerUI.this.supplierEditorSupport.openEditor(file, true);
                    }
                    ++n2;
                }
            }
        });
        return button;
    }

    private List<File> getDirectories(File file) {
        ArrayList<File> files = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                if (subFile.isDirectory()) {
                    files.add(subFile);
                }
                ++n2;
            }
        }
        return files;
    }

    private void setRootFolderContent(List<File> files) {
        Collections.sort(files);
        this.rootFolderComboViewer.setInput(files);
        if (files.size() > 0) {
            int index = this.getSelectedDirectoryIndex(files, this.preferenceStore.getString("sequenceExplorerPathParentFolder"));
            File file = files.get(index);
            this.rootFolderComboViewer.getCombo().select(index);
            List<File> subfiles = this.getDirectories(file);
            this.setSubFolderContent(subfiles);
        }
    }

    private void setSubFolderContent(List<File> files) {
        Collections.sort(files);
        this.subFolderComboViewer.setInput(files);
        if (files.size() > 0) {
            int index = this.getSelectedDirectoryIndex(files, this.preferenceStore.getString("sequenceExplorerPathSubFolder"));
            File file = files.get(index);
            this.subFolderComboViewer.getCombo().select(index);
            this.setSequenceListContent(file);
        }
    }

    private int getSelectedDirectoryIndex(List<File> files, String absolutePathDirectory) {
        int index = 0;
        int i = 0;
        while (i < files.size()) {
            if (files.get(i).getAbsolutePath().equals(absolutePathDirectory)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private void setSequenceListContent(File file) {
        if (file.isDirectory()) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(DisplayUtils.getShell());
            SequenceFileRunnable runnable = new SequenceFileRunnable(file);
            try {
                dialog.run(true, true, (IRunnableWithProgress)runnable);
                List<File> files = runnable.getSequenceFiles();
                this.sequenceFilesUI.setInput(files);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            this.sequenceFilesUI.setInput(null);
        }
    }

    private void adjustSettings() {
        File file = new File(this.preferenceStore.getString("sequenceExplorerPathRootFolder"));
        if (file.exists() && file.isDirectory()) {
            List<File> files = this.getDirectories(file);
            this.setRootFolderContent(files);
        }
        if (this.preferenceStore.getBoolean("sequenceExplorerUseSubfolder")) {
            this.subFolderComboViewer.getCombo().setEnabled(true);
        } else {
            this.subFolderComboViewer.getCombo().setEnabled(false);
        }
    }
}

