/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinition;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinitionProvider;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ProxySelectionChangedListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ProxyStructuredContentProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ProxyTableLabelProvider;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;

public class ExtendedMeasurementResultUI {
    private Label labelChromatogramInfo;
    private Label labelMeasurementResultInfo;
    private Composite toolbarChromatogramInfo;
    private Composite toolbarMeasurementResultInfo;
    private ComboViewer comboMeasurementResults;
    private TreeViewer resultTable;
    private ProxySelectionChangedListener selectionChangedListener;
    private ProxyTableLabelProvider labelProvider;
    private ProxyStructuredContentProvider contentProvider;
    private IMeasurementResult<?> lastResult;

    @Inject
    public ExtendedMeasurementResultUI(Composite parent) {
        this.initialize(parent);
    }

    public void update(Collection<IMeasurementResult<?>> results, String infoLabel) {
        if (!this.labelChromatogramInfo.isDisposed()) {
            this.labelChromatogramInfo.setText(infoLabel);
        }
        IStructuredSelection selection = this.comboMeasurementResults.getStructuredSelection();
        this.comboMeasurementResults.setInput(results);
        this.comboMeasurementResults.refresh();
        IMeasurementResult<?> selectedElement = (IMeasurementResult<?>)selection.getFirstElement();
        if (!results.contains(selectedElement)) {
            selectedElement = null;
        }
        if (selectedElement == null && results.size() == 1) {
            selectedElement = results.iterator().next();
        }
        if (selectedElement == null) {
            this.comboMeasurementResults.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            this.comboMeasurementResults.setSelection((ISelection)new StructuredSelection((Object)selectedElement));
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarChromatogramInfo = this.createToolbarChromatogramInfo(parent);
        this.toolbarMeasurementResultInfo = this.createToolbarMeasurementResultInfo(parent);
        this.resultTable = this.createResultSection(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarChromatogramInfo, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarMeasurementResultInfo, (boolean)false);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createButtonToggleChromatogramToolbarInfo(composite);
        this.comboMeasurementResults = this.createResultCombo(composite);
        this.createButtonToggleMeasurementResultToolbarInfo(composite);
    }

    public ComboViewer getComboMeasurementResults() {
        return this.comboMeasurementResults;
    }

    private Composite createToolbarChromatogramInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelChromatogramInfo = new Label(composite, 0);
        this.labelChromatogramInfo.setText("");
        this.labelChromatogramInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarMeasurementResultInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelMeasurementResultInfo = new Label(composite, 0);
        this.labelMeasurementResultInfo.setText("");
        this.labelMeasurementResultInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private TreeViewer createResultSection(Composite parent) {
        TreeViewer treeTable = ControlBuilder.createTreeTable((Composite)parent, (boolean)true);
        treeTable.getControl().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new ProxyStructuredContentProvider();
        treeTable.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ProxyTableLabelProvider();
        treeTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.selectionChangedListener = new ProxySelectionChangedListener();
        treeTable.addSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
        return treeTable;
    }

    private Button createButtonToggleChromatogramToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedMeasurementResultUI.this.toolbarChromatogramInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleMeasurementResultToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle measurement results description toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/measurementResultsDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedMeasurementResultUI.this.toolbarMeasurementResultInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/measurementResultsDefault.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/measurementResultsDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private ComboViewer createResultCombo(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IMeasurementResult) {
                    return ((IMeasurementResult)element).isVisible();
                }
                return true;
            }
        });
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IMeasurementResult) {
                    IMeasurementResult measurementResult = (IMeasurementResult)element;
                    return measurementResult.getName();
                }
                return super.getText(element);
            }
        });
        combo.setToolTipText("Show the available measurement results.");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof IMeasurementResult) {
                    ExtendedMeasurementResultUI.this.updateMeasurementResult((IMeasurementResult)object);
                } else {
                    ExtendedMeasurementResultUI.this.updateMeasurementResult(null);
                }
            }
        });
        return comboViewer;
    }

    private void updateMeasurementResult(IMeasurementResult<?> measurementResult) {
        this.updateLabel(measurementResult);
        if (this.lastResult != measurementResult) {
            TreeColumn[] columns;
            this.contentProvider.setProxy(ExtendedMeasurementResultUI.adaptTo(measurementResult, IStructuredContentProvider.class));
            this.selectionChangedListener.setProxy(ExtendedMeasurementResultUI.adaptTo(measurementResult, ISelectionChangedListener.class));
            TreeColumn[] treeColumnArray = columns = this.resultTable.getTree().getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.dispose();
                ++n2;
            }
            ColumnDefinitionProvider columnDefinitionProvider = ExtendedMeasurementResultUI.adaptTo(measurementResult, ColumnDefinitionProvider.class);
            if (columnDefinitionProvider != null) {
                for (ColumnDefinition definition : columnDefinitionProvider.getColumnDefinitions()) {
                    ControlBuilder.createColumn((TreeViewer)this.resultTable, (ColumnDefinition)definition);
                }
            }
            ITableLabelProvider tableLabelProvider = ExtendedMeasurementResultUI.adaptTo(measurementResult, ITableLabelProvider.class);
            this.labelProvider.setProxy(tableLabelProvider);
            if (tableLabelProvider != null) {
                this.resultTable.setLabelProvider((IBaseLabelProvider)tableLabelProvider);
            }
            this.resultTable.setInput(measurementResult);
        }
        this.lastResult = measurementResult;
        this.resultTable.refresh();
    }

    private static <T> T adaptTo(IMeasurementResult<?> measurementResult, Class<T> desiredType) {
        if (measurementResult == null) {
            return null;
        }
        Object resultAdapted = Adapters.adapt(measurementResult, desiredType);
        if (resultAdapted != null) {
            return (T)resultAdapted;
        }
        return (T)Adapters.adapt((Object)measurementResult.getResult(), desiredType);
    }

    public void updateLabel(IMeasurementResult<?> measurementResult) {
        if (!this.labelMeasurementResultInfo.isDisposed()) {
            if (measurementResult != null) {
                this.labelMeasurementResultInfo.setText(measurementResult.getDescription());
            } else {
                this.labelMeasurementResultInfo.setText("");
            }
        }
    }
}

