/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.text.DecimalFormat;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.support.FilterSupport;
import org.eclipse.chemclipse.msd.swt.ui.support.DatabaseFileSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanChartUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanTableUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ExtendedCombinedScanUI {
    private static final Logger logger = Logger.getLogger(ExtendedCombinedScanUI.class);
    private static final int INDEX_CHART = 0;
    private static final int INDEX_TABLE = 1;
    private Label labelInfo;
    private Composite toolbarInfo;
    private TabFolder tabFolder;
    private ScanChartUI scanChartUI;
    private ScanTableUI scanTableUI;
    private IScanMSD scanMSD;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    @Inject
    public ExtendedCombinedScanUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateScan();
    }

    public void update(Object object) {
        IScanMSD scanMSD = null;
        if (object instanceof IChromatogramSelectionMSD) {
            IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)object;
            boolean useNormalize = true;
            scanMSD = FilterSupport.getCombinedMassSpectrum((IChromatogramSelectionMSD)chromatogramSelectionMSD, null, (boolean)useNormalize);
        }
        this.labelInfo.setText(this.getCombinedRangeInfo(object));
        this.scanMSD = scanMSD;
        this.updateScan();
    }

    private void updateScan() {
        this.updateScanData();
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.createScanTabFolderSection(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createSaveButton(composite);
        this.createSettingsButton(composite);
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private void createScanTabFolderSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        this.tabFolder = new TabFolder(composite, 1024);
        this.tabFolder.setBackground(Colors.WHITE);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedCombinedScanUI.this.updateScanData();
            }
        });
        this.createScanChart(this.tabFolder);
        this.createScanTable(this.tabFolder);
    }

    private void createScanChart(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Chart");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        tabItem.setControl((Control)composite);
        this.scanChartUI = new ScanChartUI(composite, 2048);
        this.scanChartUI.setLayoutData(new GridData(1808));
    }

    private void createScanTable(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Table");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setBackground(Colors.WHITE);
        composite.setLayout((Layout)new GridLayout(1, true));
        tabItem.setControl((Control)composite);
        this.scanTableUI = new ScanTableUI(composite, 268503810);
        this.scanTableUI.getTable().setLayoutData((Object)new GridData(1808));
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedCombinedScanUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createSaveButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Save the combined scan.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/saveas.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ExtendedCombinedScanUI.this.scanMSD != null) {
                        DatabaseFileSupport.saveMassSpectrum((Shell)DisplayUtils.getShell(), (IScanMSD)ExtendedCombinedScanUI.this.scanMSD, (String)"CombinedScan");
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageScans()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedCombinedScanUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void applySettings() {
        this.updateScan();
    }

    private void updateScanData() {
        switch (this.tabFolder.getSelectionIndex()) {
            case 0: {
                if (this.scanChartUI == null) break;
                this.scanChartUI.setInput((IScan)this.scanMSD);
                break;
            }
            case 1: {
                if (this.scanTableUI == null) break;
                this.scanTableUI.setInput((IScan)this.scanMSD);
            }
        }
    }

    private String getCombinedRangeInfo(Object object) {
        StringBuilder builder = new StringBuilder();
        if (object instanceof IChromatogramSelectionMSD) {
            IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)object;
            int startRetentionTime = chromatogramSelectionMSD.getStartRetentionTime();
            int stopRetentionTime = chromatogramSelectionMSD.getStopRetentionTime();
            IChromatogram chromatogram = chromatogramSelectionMSD.getChromatogram();
            builder.append("Scan range: ");
            builder.append(chromatogram.getScanNumber(startRetentionTime));
            builder.append("\u2013");
            builder.append(chromatogram.getScanNumber(stopRetentionTime));
            builder.append(" | RT range: ");
            builder.append(this.decimalFormat.format((double)startRetentionTime / 60000.0));
            builder.append("\u2013");
            builder.append(this.decimalFormat.format((double)stopRetentionTime / 60000.0));
        } else {
            builder.append("No chromatogram selected.");
        }
        return builder.toString();
    }
}

