/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChromatogramChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageBaseline;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramChartSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class ExtendedBaselineUI {
    private ChromatogramChart chromatogramChart;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private IColorScheme colorScheme = Colors.getColorScheme((String)this.preferenceStore.getString("colorSchemeDisplayBaseline"));
    private String compressionType = this.preferenceStore.getString("Medium");
    private ChromatogramChartSupport chromatogramChartSupport = new ChromatogramChartSupport();
    private IChromatogram chromatogram;

    @Inject
    public ExtendedBaselineUI(Composite parent) {
        this.initialize(parent);
    }

    public void update(IChromatogramSelection chromatogramSelection) {
        this.chromatogram = chromatogramSelection != null ? chromatogramSelection.getChromatogram() : null;
        this.refreshBaselineChart((IChromatogram<? extends IPeak>)this.chromatogram);
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.createOverlayChart(parent);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createToggleChartLegendButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private void createToggleChartLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedBaselineUI.this.chromatogramChart.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the Overlay");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedBaselineUI.this.refreshBaselineChart((IChromatogram<? extends IPeak>)ExtendedBaselineUI.this.chromatogram);
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageBaseline preferencePage = new PreferencePageBaseline();
                preferencePage.setTitle("Baseline");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedBaselineUI.this.applyOverlaySettings();
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void createOverlayChart(Composite parent) {
        this.chromatogramChart = new ChromatogramChart(parent, 2048);
        this.chromatogramChart.setLayoutData(new GridData(1808));
        IChartSettings chartSettings = this.chromatogramChart.getChartSettings();
        chartSettings.setCreateMenu(true);
        this.chromatogramChart.applySettings(chartSettings);
    }

    private void applyOverlaySettings() {
        this.colorScheme = Colors.getColorScheme((String)this.preferenceStore.getString("colorSchemeDisplayBaseline"));
        this.compressionType = this.preferenceStore.getString("Medium");
        this.refreshBaselineChart((IChromatogram<? extends IPeak>)this.chromatogram);
    }

    private void refreshBaselineChart(IChromatogram<? extends IPeak> chromatogram) {
        this.chromatogramChart.deleteSeries();
        if (chromatogram != null) {
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            this.colorScheme.reset();
            ILineSeriesData lineSeriesDataChromatogram = this.getLineSeriesData(chromatogram, "Chromatogram", false);
            ILineSeriesSettings lineSeriesSettingsChromatogram = lineSeriesDataChromatogram.getSettings();
            lineSeriesSettingsChromatogram.setLineColor(this.colorScheme.getColor());
            lineSeriesSettingsChromatogram.setEnableArea(false);
            lineSeriesDataList.add(lineSeriesDataChromatogram);
            ILineSeriesData lineSeriesDataBaseline = this.getLineSeriesData(chromatogram, "Baseline", true);
            ILineSeriesSettings lineSeriesSettingsBaseline = lineSeriesDataBaseline.getSettings();
            lineSeriesSettingsBaseline.setLineColor(this.colorScheme.getNextColor());
            lineSeriesSettingsBaseline.setEnableArea(false);
            lineSeriesDataList.add(lineSeriesDataBaseline);
            int compressionToLength = this.chromatogramChartSupport.getCompressionLength(this.compressionType, lineSeriesDataList.size());
            this.chromatogramChart.addSeriesData(lineSeriesDataList, compressionToLength);
        }
    }

    private ILineSeriesData getLineSeriesData(IChromatogram<? extends IPeak> chromatogram, String id, boolean baseline) {
        ISeriesData seriesData = this.getSeriesDataProcessed(chromatogram, id, baseline);
        LineSeriesData lineSeriesData = new LineSeriesData(seriesData);
        return lineSeriesData;
    }

    private ISeriesData getSeriesDataProcessed(IChromatogram<? extends IPeak> chromatogram, String id, boolean baseline) {
        double[] ySeries;
        double[] xSeries;
        if (chromatogram != null) {
            IBaselineModel baselineModel = chromatogram.getBaselineModel();
            int size = chromatogram.getNumberOfScans();
            xSeries = new double[size];
            ySeries = new double[size];
            int index = 0;
            for (IScan scan : chromatogram.getScans()) {
                int retentionTime = scan.getRetentionTime();
                xSeries[index] = retentionTime;
                ySeries[index] = baseline ? baselineModel.getBackgroundAbundance(retentionTime) : scan.getTotalSignal();
                ++index;
            }
        } else {
            xSeries = new double[]{};
            ySeries = new double[]{};
        }
        return new SeriesData(xSeries, ySeries, id);
    }
}

