/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.ranges;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.ranges.TimeRange;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class TimeRangeValidator
implements IValidator {
    private static final String ERROR = "Please enter a correct retention time in minutes, e.g.: 4.25.";
    private TimeRange.Marker marker = null;
    private TimeRange timeRange = null;
    private int retentionTime = 0;
    private String identifier = "";
    private int retentionTimeStart = 0;
    private int retentionTimeCenter = 0;
    private int retentionTimeStop = 0;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public TimeRangeValidator() {
        this(null);
    }

    public TimeRangeValidator(TimeRange.Marker marker) {
        this.marker = marker;
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public IStatus validate(Object value) {
        String message = null;
        this.retentionTime = 0;
        if (value == null) {
            message = ERROR;
        } else if (value instanceof String) {
            if (this.marker != null) {
                this.parseSpecificMarker((String)value);
            } else {
                this.parseAllMarker((String)value);
            }
        } else {
            message = ERROR;
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    private String parseSpecificMarker(String value) {
        String message;
        block12: {
            message = null;
            try {
                double retentionTimeMinutes = Double.parseDouble(value.trim());
                if (retentionTimeMinutes < 0.0) {
                    message = "The retention time must be > 0.0.";
                    break block12;
                }
                this.retentionTime = (int)(retentionTimeMinutes * 60000.0);
                if (this.timeRange == null) break block12;
                switch (this.marker) {
                    case START: {
                        if (this.retentionTime > this.timeRange.getCenter()) {
                            message = "The retention time must be <= center (" + this.getRetentionTimeMinutes(this.timeRange.getCenter()) + ").";
                        }
                        break;
                    }
                    case CENTER: {
                        if (this.retentionTime < this.timeRange.getStart() || this.retentionTime > this.timeRange.getStop()) {
                            message = "The retention time must be >= start (" + this.getRetentionTimeMinutes(this.timeRange.getStart()) + ") and <= stop (" + this.getRetentionTimeMinutes(this.timeRange.getStop()) + ").";
                        }
                        break;
                    }
                    case STOP: {
                        if (this.retentionTime >= this.timeRange.getCenter()) break;
                        message = "The retention time must be >= center (" + this.getRetentionTimeMinutes(this.timeRange.getCenter()) + ").";
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                message = ERROR;
            }
        }
        return message;
    }

    private String parseAllMarker(String value) {
        String message = null;
        try {
            String[] values = value.split("|");
            if (values.length == 4) {
                this.identifier = values[0].trim();
                this.retentionTimeStart = (int)(Double.parseDouble(values[1].trim()) * 60000.0);
                this.retentionTimeCenter = (int)(Double.parseDouble(values[2].trim()) * 60000.0);
                this.retentionTimeStop = (int)(Double.parseDouble(values[3].trim()) * 60000.0);
                if ("".equals(this.identifier)) {
                    message = "Please specify an identifier.";
                } else if (this.retentionTimeStart > this.retentionTimeCenter) {
                    message = "Start > Center";
                } else if (this.retentionTimeStart > this.retentionTimeCenter || this.retentionTimeStart > this.retentionTimeStop) {
                    message = "Start > Stop";
                } else if (this.retentionTimeCenter > this.retentionTimeStop) {
                    message = "Center > Stop";
                }
            }
        }
        catch (Exception e) {
            message = "Input is invalid.";
        }
        return message;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    private String getRetentionTimeMinutes(int milliseconds) {
        return this.decimalFormat.format((float)milliseconds / 60000.0f);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getRetentionTimeStart() {
        return this.retentionTimeStart;
    }

    public int getRetentionTimeCenter() {
        return this.retentionTimeCenter;
    }

    public int getRetentionTimeStop() {
        return this.retentionTimeStop;
    }
}

