/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.part.support;

import java.io.File;
import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.ux.extension.ui.editors.EditorDescriptor;
import org.eclipse.chemclipse.ux.extension.ui.provider.ISupplierFileEditorSupport;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;

public class GenericSupplierEditorSupport
implements ISupplierFileEditorSupport {
    private static final Object NO_EXECUTE_METHOD = new Object();
    private final Supplier<IEclipseContext> contextSupplier;
    private final ISupplierFileIdentifier fileIdentifier;

    public GenericSupplierEditorSupport(ISupplierFileIdentifier fileIdentifier, Supplier<IEclipseContext> contextSupplier) {
        this.fileIdentifier = fileIdentifier;
        this.contextSupplier = contextSupplier;
    }

    public String getType() {
        return "Generic";
    }

    public boolean isSupplierFile(File file) {
        return false;
    }

    public Collection<ISupplier> getSupplier(File file) {
        return this.fileIdentifier.getSupplier(file);
    }

    public Collection<ISupplier> getSupplier() {
        return this.fileIdentifier.getSupplier();
    }

    public boolean openEditor(File file, boolean batch) {
        return false;
    }

    public boolean openEditor(File file, ISupplier supplier) {
        IEclipseContext eclipseContext = this.contextSupplier.get();
        IEclipseContext parameterContext = EclipseContextFactory.create();
        try {
            Object[] executables;
            parameterContext.set(File.class, (Object)file);
            parameterContext.set(ISupplier.class, (Object)supplier);
            Object[] objectArray = executables = new Object[]{Adapters.adapt((Object)supplier, EditorDescriptor.class), supplier};
            int n = executables.length;
            int n2 = 0;
            while (n2 < n) {
                Object invoke;
                Object executable = objectArray[n2];
                if (executable != null && NO_EXECUTE_METHOD != (invoke = ContextInjectionFactory.invoke((Object)executable, Execute.class, (IEclipseContext)eclipseContext, (IEclipseContext)parameterContext, (Object)NO_EXECUTE_METHOD))) {
                    if (invoke instanceof Boolean) {
                        boolean bl = (Boolean)invoke;
                        return bl;
                    }
                    return true;
                }
                ++n2;
            }
        }
        finally {
            parameterContext.dispose();
        }
        return false;
    }
}

