/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.part.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.nmr.model.selection.IDataNMRSelection;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.ux.extension.ui.editors.IChromatogramEditor;
import org.eclipse.chemclipse.ux.extension.ui.editors.IChromatogramProjectEditor;
import org.eclipse.chemclipse.ux.extension.ui.editors.IQuantitationDatabaseEditor;
import org.eclipse.chemclipse.ux.extension.ui.editors.IScanEditorNMR;
import org.eclipse.chemclipse.ux.extension.ui.editors.IScanEditorXIR;
import org.eclipse.chemclipse.xir.model.core.IScanXIR;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;

public class EditorUpdateSupport {
    private static final Logger logger = Logger.getLogger(EditorUpdateSupport.class);
    private EPartService partService = ModelSupportAddon.getPartService();

    public IChromatogramSelection getActiveEditorSelection() {
        if (this.partService != null) {
            try {
                Collection parts = this.partService.getParts();
                if (parts != null) {
                    for (MPart part : parts) {
                        Object object;
                        if (!part.isVisible() || !((object = part.getObject()) instanceof IChromatogramEditor)) continue;
                        return ((IChromatogramEditor)object).getChromatogramSelection();
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public List<IChromatogramSelection> getChromatogramSelections() {
        block5: {
            chromatogramSelections = new ArrayList<IChromatogramSelection>();
            if (this.partService != null) {
                try {
                    parts = this.partService.getParts();
                    if (parts == null) break block5;
                    for (MPart part : parts) {
                        chromatogramSelections.addAll(this.extractChromatogramSelections(part.getObject()));
                    }
                    break block5;
                }
                catch (Exception e) {
                    application = ModelSupportAddon.getApplication();
                    if (application == null || (service = ModelSupportAddon.getModelService()) == null || (parts = service.findElements((MUIElement)application, null, MPart.class, null)) == null) break block5;
                    ** for (part : parts)
                }
lbl-1000:
                // 1 sources

                {
                    if (this.extractChromatogramSelections(part.getObject()).size() <= 0) continue;
                    chromatogramSelections.addAll(this.extractChromatogramSelections(part.getObject()));
                    continue;
                }
            }
        }
        return chromatogramSelections;
    }

    public List<IScanXIR> getScanSelectionsXIR() {
        ArrayList<IScanXIR> dataNMRSelections = new ArrayList<IScanXIR>();
        if (this.partService != null) {
            try {
                Collection parts = this.partService.getParts();
                for (MPart part : parts) {
                    Object object = part.getObject();
                    if (object == null) continue;
                    IScanXIR selection = null;
                    if (object instanceof IScanEditorXIR) {
                        IScanEditorXIR editor = (IScanEditorXIR)object;
                        selection = editor.getScanSelection();
                    }
                    if (selection == null) continue;
                    dataNMRSelections.add(selection);
                }
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return dataNMRSelections;
    }

    public List<IDataNMRSelection> getDataNMRSelections(EPartService partService) {
        ArrayList<IDataNMRSelection> scanSelections = new ArrayList<IDataNMRSelection>();
        Collection parts = partService.getParts();
        for (MPart part : parts) {
            IScanEditorNMR editor;
            IDataNMRSelection selection;
            Object object = part.getObject();
            if (!(object instanceof IScanEditorNMR) || (selection = (editor = (IScanEditorNMR)object).getScanSelection()) == null) continue;
            scanSelections.add(selection);
        }
        return scanSelections;
    }

    public List<IQuantitationDatabase> getQuantitationDatabases() {
        ArrayList<IQuantitationDatabase> quantitationDatabases = new ArrayList<IQuantitationDatabase>();
        if (this.partService != null) {
            try {
                Collection parts = this.partService.getParts();
                for (MPart part : parts) {
                    Object object = part.getObject();
                    if (!(object instanceof IQuantitationDatabaseEditor)) continue;
                    IQuantitationDatabaseEditor editor = (IQuantitationDatabaseEditor)object;
                    quantitationDatabases.add(editor.getQuantitationDatabase());
                }
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return quantitationDatabases;
    }

    private void addChromatogramSelection(List<IChromatogramSelection> chromatogramSelections, IChromatogramSelection selection) {
        if (selection != null) {
            chromatogramSelections.add(selection);
        }
    }

    private void addChromatogramSelections(List<IChromatogramSelection> chromatogramSelections, List<IChromatogramSelection> selections) {
        if (selections != null && selections.size() > 0) {
            chromatogramSelections.addAll(selections);
        }
    }

    private List<IChromatogramSelection> extractChromatogramSelections(Object object) {
        ArrayList<IChromatogramSelection> chromatogramSelections = new ArrayList<IChromatogramSelection>();
        if (object != null) {
            if (object instanceof IChromatogramEditor) {
                this.addChromatogramSelection(chromatogramSelections, ((IChromatogramEditor)object).getChromatogramSelection());
            } else if (object instanceof IChromatogramProjectEditor) {
                this.addChromatogramSelections(chromatogramSelections, ((IChromatogramProjectEditor)object).getChromatogramSelections());
            } else if (object instanceof CompatibilityEditor) {
                CompatibilityEditor compatibilityEditor = (CompatibilityEditor)object;
                IWorkbenchPart workbenchPart = compatibilityEditor.getPart();
                if (workbenchPart instanceof IChromatogramEditor) {
                    this.addChromatogramSelection(chromatogramSelections, ((IChromatogramEditor)workbenchPart).getChromatogramSelection());
                } else if (workbenchPart instanceof IChromatogramProjectEditor) {
                    this.addChromatogramSelections(chromatogramSelections, ((IChromatogramProjectEditor)workbenchPart).getChromatogramSelections());
                }
            }
        }
        return chromatogramSelections;
    }
}

