/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.part.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateListener;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DataUpdateSupport {
    private IEventBroker eventBroker;
    private Map<String, EventHandler> handlerMap = new HashMap<String, EventHandler>();
    private Map<String, List<Object>> objectMap = new HashMap<String, List<Object>>();
    private List<IDataUpdateListener> updateListeners = new ArrayList<IDataUpdateListener>();

    public DataUpdateSupport(IEventBroker eventBroker) throws IllegalArgumentException {
        if (eventBroker == null) {
            throw new IllegalArgumentException("The event broker must be not null.");
        }
        this.eventBroker = eventBroker;
    }

    public void add(IDataUpdateListener updateListener) {
        if (updateListener != null) {
            this.updateListeners.add(updateListener);
        }
    }

    public void remove(IDataUpdateListener updateListener) {
        if (updateListener != null) {
            this.updateListeners.remove(updateListener);
        }
    }

    public List<Object> getUpdates(String topic) {
        return this.objectMap.getOrDefault(topic, Collections.EMPTY_LIST);
    }

    public void subscribe(String topic, String property) {
        this.subscribe(topic, new String[]{property});
    }

    public void subscribe(String topic, String[] properties) {
        if (topic != null && !"".equals(topic) && properties != null) {
            this.registerEventHandler(topic, properties);
        }
    }

    public void unsubscribe(String topic) {
        EventHandler eventHandler = this.handlerMap.get(topic);
        if (eventHandler != null) {
            this.eventBroker.unsubscribe(eventHandler);
        }
    }

    protected void finalize() throws Throwable {
        this.unsubscribeEvents();
        super.finalize();
    }

    private void unsubscribeEvents() {
        if (this.eventBroker != null) {
            for (EventHandler eventHandler : this.handlerMap.values()) {
                this.eventBroker.unsubscribe(eventHandler);
            }
        }
        this.handlerMap.clear();
        this.objectMap.clear();
    }

    private void registerEventHandler(String topic, final String[] properties) {
        EventHandler eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                DataUpdateSupport.this.update(event, properties);
            }
        };
        if (this.handlerMap.containsKey(topic)) {
            this.unsubscribe(topic);
        }
        this.eventBroker.subscribe(topic, eventHandler);
        this.handlerMap.put(topic, eventHandler);
    }

    private void update(Event event, String[] properties) {
        String topic = event.getTopic();
        if (!this.objectMap.containsKey(topic)) {
            this.objectMap.put(topic, new ArrayList());
        }
        List<Object> objects = this.objectMap.get(topic);
        objects.clear();
        if (properties != null) {
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                Object object = event.getProperty(property);
                if (object != null) {
                    objects.add(object);
                }
                ++n2;
            }
        }
        this.objectMap.put(topic, objects);
        this.fireUpdate(topic, objects);
    }

    private void fireUpdate(String topic, List<Object> objects) {
        for (IDataUpdateListener updateListener : this.updateListeners) {
            updateListener.update(topic, objects);
        }
    }
}

