/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.model;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.model.ColorCode;
import org.eclipse.swt.graphics.Color;

public class ColorCodes
extends HashMap<String, ColorCode> {
    public static final String ENTRY_DELIMITER = ";";
    public static final String VALUE_DELIMITER = ":";
    private static final long serialVersionUID = 5166193750159157107L;
    private static final Logger logger = Logger.getLogger(ColorCodes.class);

    public void add(ColorCode colorCode) {
        if (colorCode != null) {
            this.put(colorCode.getName(), colorCode);
        }
    }

    public void load(String codes) {
        this.loadSettings(codes);
    }

    public void loadDefault(String codes) {
        this.loadSettings(codes);
    }

    public String save() {
        StringBuilder builder = new StringBuilder();
        if (this.size() >= 1) {
            for (ColorCode colorCode : this.values()) {
                builder.append(colorCode.getName());
                builder.append(VALUE_DELIMITER);
                builder.append(Colors.getColor((Color)colorCode.getColor()));
                builder.append(ENTRY_DELIMITER);
            }
        }
        return builder.toString().trim();
    }

    private void loadSettings(String codes) {
        String[] items;
        if (!"".equals(codes) && (items = ColorCodes.parseString(codes)).length > 0) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                try {
                    String[] values = item.split(VALUE_DELIMITER);
                    if (values.length > 1) {
                        String name = values[0];
                        Color color = Colors.getColor((String)values[1]);
                        ColorCode colorCode = new ColorCode(name, color);
                        this.add(colorCode);
                    }
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
                ++n2;
            }
        }
    }

    private static String[] parseString(String string) {
        String[] decodedArray = new String[]{};
        if (string.contains(ENTRY_DELIMITER)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ENTRY_DELIMITER);
            int arraySize = stringTokenizer.countTokens();
            decodedArray = new String[arraySize];
            int i = 0;
            while (i < arraySize) {
                decodedArray[i] = stringTokenizer.nextToken(ENTRY_DELIMITER);
                ++i;
            }
        } else if (string.contains(VALUE_DELIMITER)) {
            decodedArray = new String[]{string};
        }
        return decodedArray;
    }
}

