/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation;

import org.eclipse.chemclipse.model.quantitation.IQuantitationSignal;
import org.eclipse.chemclipse.model.quantitation.QuantitationSignal;
import org.eclipse.chemclipse.support.util.ValueParserSupport;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class QuantitationSignalValidator
extends ValueParserSupport
implements IValidator {
    public static final String DEMO = "TIC | 100.0 | 0.0 | true";
    private static final String DELIMITER = "|";
    private static final String ERROR_TARGET = "Please enter a signal, e.g.: TIC | 100.0 | 0.0 | true";
    private double signal;
    private float relativeResponse;
    private double uncertainty;
    private boolean use;

    public IStatus validate(Object value) {
        String message = null;
        if (value == null) {
            message = ERROR_TARGET;
        } else if (value instanceof String) {
            String text = ((String)value).trim();
            if ("".equals(text.trim())) {
                message = ERROR_TARGET;
            } else {
                String[] values = text.trim().split("\\|");
                String signalValue = this.parseString(values, 0);
                this.signal = "TIC".equals(signalValue) ? 0.0 : this.parseDouble(values, 0);
                this.relativeResponse = this.parseFloat(values, 1);
                this.uncertainty = this.parseDouble(values, 2);
                this.use = this.parseBoolean(values, 3);
            }
        } else {
            message = ERROR_TARGET;
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public IQuantitationSignal getQuantitationSignal() {
        return new QuantitationSignal(this.signal, (double)this.relativeResponse, this.uncertainty, this.use);
    }
}

