/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.pcr.converter.core.PlateConverterPCR;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PCRExportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(PCRExportRunnable.class);
    private File file;
    private IPlate plate;
    private ISupplier supplier;
    private File data = null;

    public PCRExportRunnable(File file, IPlate plate, ISupplier supplier) {
        this.file = file;
        this.plate = plate;
        this.supplier = supplier;
    }

    public File getData() {
        return this.data;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Export Plate", -1);
                IProcessingInfo processingInfo = PlateConverterPCR.convert((File)this.file, (IPlate)this.plate, (String)this.supplier.getId(), (IProgressMonitor)monitor);
                this.data = (File)processingInfo.getProcessingResult();
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

