/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramLengthModifier
implements IRunnableWithProgress {
    private IChromatogramSelection chromatogramSelection;
    private int scanDelay;
    private int chromatogramLength;

    public ChromatogramLengthModifier(IChromatogramSelection chromatogramSelection, int scanDelay, int chromatogramLength) {
        this.chromatogramSelection = chromatogramSelection;
        this.scanDelay = scanDelay;
        this.chromatogramLength = chromatogramLength;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Chromatogram Length Modified", -1);
            IChromatogram chromatogram = this.chromatogramSelection.getChromatogram();
            int scanRange = chromatogram.getNumberOfScans() - 1;
            if (scanRange > 0) {
                this.chromatogramSelection.setSelectedPeak(null);
                this.chromatogramSelection.setSelectedScan(null);
                this.chromatogramSelection.setSelectedIdentifiedScan(null);
                chromatogram.getBaselineModel().removeBaseline();
                chromatogram.removeAllBackgroundIntegrationEntries();
                chromatogram.removeAllChromatogramIntegrationEntries();
                chromatogram.removeAllMeasurementResults();
                chromatogram.removeAllPeaks();
                chromatogram.getTargets().clear();
                float retentionTimeRange = this.chromatogramLength - this.scanDelay;
                int scanInterval = Math.round(retentionTimeRange / (float)scanRange);
                chromatogram.setScanDelay(this.scanDelay);
                chromatogram.setScanInterval(scanInterval);
                chromatogram.recalculateRetentionTimes();
                int startRetentionTime = this.scanDelay;
                if (this.chromatogramSelection.getStartRetentionTime() < startRetentionTime) {
                    this.chromatogramSelection.setStartRetentionTime(startRetentionTime);
                }
                int stopRetentionTime = chromatogram.getStopRetentionTime();
                if (this.chromatogramSelection.getStopRetentionTime() > stopRetentionTime) {
                    this.chromatogramSelection.setStopRetentionTime(stopRetentionTime);
                }
            }
        }
        finally {
            monitor.done();
        }
    }
}

