/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.ranges.TimeRange;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class TimeRangesLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String IDENTIFIER = "Identifier";
    public static final String START = "Start Time [min]";
    public static final String CENTER = "Center Time [min]";
    public static final String STOP = "Stop Time [min]";
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");
    public static final String[] TITLES = new String[]{"Identifier", "Start Time [min]", "Center Time [min]", "Stop Time [min]"};
    public static final int[] BOUNDS = new int[]{200, 130, 130, 130};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof TimeRange) {
            TimeRange timeRange = (TimeRange)element;
            switch (columnIndex) {
                case 0: {
                    text = timeRange.getIdentifier();
                    break;
                }
                case 1: {
                    text = this.calculateRetentionTimeMinutes(timeRange.getStart());
                    break;
                }
                case 2: {
                    text = this.calculateRetentionTimeMinutes(timeRange.getCenter());
                    break;
                }
                case 3: {
                    text = this.calculateRetentionTimeMinutes(timeRange.getStop());
                }
            }
        }
        return text;
    }

    private String calculateRetentionTimeMinutes(int retentionTime) {
        return this.decimalFormat.format((float)retentionTime / 60000.0f);
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/targets.gif", "16x16");
    }
}

