/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.quantitation.IQuantitationSignal;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class QuantSignalsLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String SIGNAL = "Signal";
    public static final String RELATIVE_RESPONSE = "Relative Response";
    public static final String UNCERTAINTY = "Uncertainty";
    public static final String USE = "Use";
    public static final String[] TITLES = new String[]{"Signal", "Relative Response", "Uncertainty", "Use"};
    public static final int[] BOUNDS = new int[]{100, 100, 100, 100};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        if (columnIndex == 3 && element instanceof IQuantitationSignal) {
            IQuantitationSignal signal = (IQuantitationSignal)element;
            String fileName = signal.isUse() ? "org.eclipse.chemclipse.rcp.ui.icons/selected.gif" : "org.eclipse.chemclipse.rcp.ui.icons/deselected.gif";
            return ApplicationImageFactory.getInstance().getImage(fileName, "16x16");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IQuantitationSignal) {
            IQuantitationSignal entry = (IQuantitationSignal)element;
            switch (columnIndex) {
                case 0: {
                    double signal = entry.getSignal();
                    if (signal == 0.0) {
                        text = "TIC";
                        break;
                    }
                    text = decimalFormat.format(signal);
                    break;
                }
                case 1: {
                    text = decimalFormat.format(entry.getRelativeResponse());
                    break;
                }
                case 2: {
                    text = decimalFormat.format(entry.getUncertainty());
                    break;
                }
                case 3: {
                    text = "";
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/quantifySelectedPeak.gif", "16x16");
    }
}

