/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.ITargetSupplier;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PeakTableTargetLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IPeak) {
            IPeak peak = (IPeak)element;
            IPeakModel peakModel = peak.getPeakModel();
            IScan peakMaximum = peakModel.getPeakMaximum();
            ArrayList peakTargets = new ArrayList();
            if (peak instanceof ITargetSupplier) {
                IPeak targetSupplier = peak;
                peakTargets.addAll(targetSupplier.getTargets());
            }
            String peakTarget = "";
            if (peakTargets != null && peakTargets.size() > 0) {
                Collections.sort(peakTargets, this.targetExtendedComparator);
                peakTarget = ((IIdentificationTarget)peakTargets.get(0)).getLibraryInformation().getName();
            }
            switch (columnIndex) {
                case 0: {
                    text = this.decimalFormat.format((double)peakMaximum.getRetentionTime() / 60000.0);
                    break;
                }
                case 1: {
                    text = peakTarget;
                    break;
                }
                case 2: {
                    if (peak instanceof IChromatogramPeakMSD) {
                        text = this.decimalFormat.format(((IChromatogramPeakMSD)peak).getSignalToNoiseRatio());
                        break;
                    }
                    if (!(peak instanceof IChromatogramPeakCSD)) break;
                    text = this.decimalFormat.format(((IChromatogramPeakCSD)peak).getSignalToNoiseRatio());
                    break;
                }
                case 3: {
                    text = this.decimalFormat.format(peak.getIntegratedArea());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/peak.gif", "16x16");
    }
}

