/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Composite;

public class IntegerColumnEditingSupport<T>
extends EditingSupport {
    private final Function<T, Integer> extractorFunction;
    private final BiConsumer<T, Integer> updateFunction;

    public IntegerColumnEditingSupport(ColumnViewer viewer, Function<T, Integer> extractorFunction, BiConsumer<T, Integer> updateFunction) {
        super(viewer);
        this.extractorFunction = extractorFunction;
        this.updateFunction = updateFunction;
    }

    protected boolean canEdit(Object object) {
        return this.extractorFunction.apply(this.getEditObject(object)) != null;
    }

    private T getEditObject(Object object) {
        if (object instanceof TreeNode) {
            object = ((TreeNode)object).getValue();
        }
        return (T)object;
    }

    protected CellEditor getCellEditor(Object object) {
        return new TextCellEditor((Composite)this.getViewer().getControl());
    }

    protected Object getValue(Object object) {
        return String.valueOf(this.extractorFunction.apply(this.getEditObject(object)));
    }

    protected void setValue(Object element, Object value) {
        if (value instanceof String) {
            try {
                int integer = Integer.parseInt((String)value);
                this.updateFunction.accept(this.getEditObject(element), integer);
                this.getViewer().refresh(element);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

