/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.listener;

import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swtchart.ICustomPaintListener;

public class SplitSelectionPaintListener
implements ICustomPaintListener {
    private static final String LABEL_PERPENDICULAR_DROP = "P";
    private static final String LABEL_TANGENT_SKIM = "T";
    private int x1;
    private int y1;
    private int x2;
    private int y2;

    public void paintControl(PaintEvent e) {
        Color foreground = e.gc.getForeground();
        Color background = e.gc.getBackground();
        e.gc.setForeground(DisplayUtils.getDisplay().getSystemColor(2));
        if (this.x1 == this.x2) {
            if (this.x1 != 0) {
                Point position = this.getLabelPosition(e, this.x1, this.y1, LABEL_PERPENDICULAR_DROP);
                e.gc.drawText(LABEL_PERPENDICULAR_DROP, position.x, position.y);
                e.gc.drawLine(this.x1, this.y1, this.x1, e.height);
            }
        } else {
            Point position;
            if (this.x1 != 0) {
                position = this.getLabelPosition(e, this.x1, this.y1, LABEL_TANGENT_SKIM);
                e.gc.drawText(LABEL_TANGENT_SKIM, position.x, position.y);
                e.gc.drawLine(this.x1, this.y1, this.x1, e.height);
            }
            if (this.x2 != 0) {
                position = this.getLabelPosition(e, this.x2, this.y2, LABEL_TANGENT_SKIM);
                e.gc.drawText(LABEL_TANGENT_SKIM, position.x, position.y);
                e.gc.drawLine(this.x2, this.y2, this.x2, e.height);
            }
        }
        e.gc.setForeground(foreground);
        e.gc.setBackground(background);
    }

    private Point getLabelPosition(PaintEvent e, int x, int y, String label) {
        Point labelSize = e.gc.textExtent(label);
        int xPosition = x - (int)((double)labelSize.x / 2.0);
        int yPosition = y - labelSize.y;
        return new Point(xPosition, yPosition);
    }

    public boolean drawBehindSeries() {
        return false;
    }

    public void reset() {
        this.x1 = 0;
        this.y1 = 0;
        this.x2 = 0;
        this.y2 = 0;
    }

    public void setX1(int x1) {
        this.x1 = x1;
    }

    public void setY1(int y1) {
        this.y1 = y1;
    }

    public void setX2(int x2) {
        this.x2 = x2;
    }

    public void setY2(int y2) {
        this.y2 = y2;
    }
}

