/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.scan.IScanConverterSupport;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.pcr.converter.core.PlateConverterPCR;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.PCRExportRunnable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class PCRFileSupport {
    private static final Logger logger = Logger.getLogger(PCRFileSupport.class);

    private PCRFileSupport() {
    }

    public static boolean savePlate(Shell shell, IPlate plate) throws NoConverterAvailableException {
        if (plate == null || shell == null) {
            return false;
        }
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterPath(Activator.getDefault().getSettingsPath());
        dialog.setFileName(plate.getName());
        dialog.setText("Save Plate As...");
        dialog.setOverwrite(true);
        IScanConverterSupport converterSupport = PlateConverterPCR.getScanConverterSupport();
        if (converterSupport != null) {
            String[] filterExtensions = converterSupport.getExportableFilterExtensions();
            dialog.setFilterExtensions(filterExtensions);
            String[] filterNames = converterSupport.getExportableFilterNames();
            dialog.setFilterNames(filterNames);
            String filename = dialog.open();
            if (filename != null) {
                PCRFileSupport.validateFile(dialog, converterSupport.getExportSupplier(), shell, converterSupport, plate);
                return true;
            }
            return false;
        }
        return false;
    }

    public static void writeFile(Shell shell, File file, IPlate plate, ISupplier supplier) {
        if (file == null || plate == null || supplier == null) {
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        PCRExportRunnable runnable = new PCRExportRunnable(file, plate, supplier);
        try {
            dialog.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        File data = runnable.getData();
        if (data == null) {
            MessageDialog.openInformation((Shell)shell, (String)"Save PCR", (String)"There is no suitable plate converter available.");
        }
    }

    private static void validateFile(FileDialog dialog, List<ISupplier> supplier, Shell shell, IScanConverterSupport converterSupport, IPlate plate) {
        File plateFolder = null;
        boolean overwrite = dialog.getOverwrite();
        boolean folderExists = false;
        boolean isDirectory = false;
        ISupplier selectedSupplier = supplier.get(dialog.getFilterIndex());
        if (selectedSupplier == null) {
            MessageDialog.openInformation((Shell)shell, (String)"PCR Converter", (String)"The requested plate converter does not exists.");
            return;
        }
        String filename = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName();
        if (selectedSupplier != null) {
            String directoryExtension = selectedSupplier.getDirectoryExtension();
            if (directoryExtension != "") {
                isDirectory = true;
                filename = PCRFileSupport.removeFileExtensions(filename, selectedSupplier);
                plateFolder = new File(filename = filename.concat(selectedSupplier.getDirectoryExtension()));
                if (plateFolder.exists()) {
                    folderExists = true;
                    overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite", (String)("Would you like to overwrite the plate " + plateFolder.toString() + "?"));
                }
                if (overwrite && !folderExists) {
                    plateFolder.mkdir();
                }
            } else {
                File dataFile;
                String filenameDialog;
                filename = PCRFileSupport.removeFileExtensions(filename, selectedSupplier);
                if (!(filename = filename.concat(selectedSupplier.getFileExtension())).equals(filenameDialog = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName()) && (dataFile = new File(filename)).exists()) {
                    overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite", (String)("Would you like to overwrite the plate " + dataFile.toString() + "?"));
                }
            }
            if (overwrite) {
                if (isDirectory) {
                    if (!folderExists && plateFolder != null) {
                        plateFolder.mkdir();
                    }
                } else {
                    String fileExtension = selectedSupplier.getFileExtension();
                    if (!filename.endsWith(fileExtension)) {
                        filename = String.valueOf(filename) + fileExtension;
                    }
                }
                PCRFileSupport.writeFile(shell, new File(filename), plate, selectedSupplier);
            }
        }
    }

    private static String removeFileExtensions(String filePath, ISupplier supplier) {
        int start = 0;
        int stop = 0;
        if (supplier.getDirectoryExtension().equals("")) {
            String fileExtension = supplier.getFileExtension();
            if (filePath.endsWith(fileExtension) || filePath.endsWith(fileExtension.toLowerCase()) || filePath.endsWith(fileExtension.toUpperCase())) {
                stop = filePath.length() - fileExtension.length();
                filePath = filePath.substring(start, stop);
            }
        } else {
            String directoryExtension = supplier.getDirectoryExtension();
            if (filePath.endsWith(directoryExtension) || filePath.endsWith(directoryExtension.toLowerCase()) || filePath.endsWith(directoryExtension.toUpperCase())) {
                stop = filePath.length() - directoryExtension.length();
                filePath = filePath.substring(start, stop);
            }
        }
        return filePath;
    }
}

