/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.io.File;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.chemclipse.converter.methods.MethodConverter;
import org.eclipse.chemclipse.model.handler.IModificationHandler;
import org.eclipse.chemclipse.model.methods.ProcessMethod;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.chemclipse.support.ui.workbench.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.ProcessMethodNotifications;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedMethodUI;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ProcessMethodEditor
implements IModificationHandler {
    public static final String SNIPPET_ID = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.processMethodEditor";
    @Inject
    private MPart part;
    private File processMethodFile;
    private ExtendedMethodUI extendedMethodUI;
    @Inject
    private ProcessMethodNotifications notifications;
    @Inject
    private PartSupport partsupport;
    private IProcessMethod currentProcessMethod;
    @Inject
    private ProcessSupplierContext processSupplierContext;

    @Focus
    public void setFocus() {
        this.extendedMethodUI.setFocus();
    }

    @PreDestroy
    private void preDestroy() {
        this.partsupport.closePart(this.part);
    }

    @Persist
    public void save(@Named(value="activeShell") Shell shell) {
        File saveFile = this.getSaveFile(shell);
        if (saveFile != null) {
            IProcessingInfo info;
            IProcessMethod oldMethod = this.currentProcessMethod;
            IProcessMethod editedMethod = this.extendedMethodUI.getProcessMethod();
            ProcessMethod newMethod = new ProcessMethod(editedMethod);
            newMethod.setSourceFile(saveFile);
            newMethod.setUUID(oldMethod.getUUID());
            if (editedMethod.isFinal()) {
                newMethod.setReadOnly(editedMethod.isFinal());
            }
            if ((info = MethodConverter.convert((File)saveFile, (IProcessMethod)newMethod, (String)"org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.processMethodSupplier", (IProgressMonitor)new NullProgressMonitor())).hasErrorMessages()) {
                ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)info);
            } else {
                this.part.setDirty(false);
                this.currentProcessMethod = newMethod;
                this.notifications.updated(newMethod, oldMethod);
                this.processMethodFile = saveFile;
                this.part.setLabel(String.valueOf(this.processMethodFile.getName()) + " " + this.currentProcessMethod.getDataCategories());
            }
        }
    }

    private File getSaveFile(Shell shell) {
        String selectedFile;
        if (this.processMethodFile != null && this.processMethodFile.exists()) {
            return this.processMethodFile;
        }
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText("Save Process Method as");
        String methodName = this.extendedMethodUI.getMethodName();
        if (methodName.isEmpty()) {
            fileDialog.setFileName("ProcessMethod.ocm");
        } else {
            fileDialog.setFileName(String.valueOf(methodName) + "." + "ocm");
        }
        fileDialog.setFilterExtensions(MethodConverter.DEFAULT_METHOD_FILE_EXTENSIONS);
        fileDialog.setFilterNames(MethodConverter.DEFAULT_METHOD_FILE_NAMES);
        File userDirectory = MethodConverter.getUserMethodDirectory();
        if (userDirectory.exists()) {
            fileDialog.setFilterPath(MethodConverter.getUserMethodDirectory().getAbsolutePath());
        }
        if ((selectedFile = fileDialog.open()) != null) {
            File file = new File(selectedFile);
            if (!userDirectory.exists()) {
                MethodConverter.setUserMethodDirectory((File)file.getParentFile());
            }
            return file;
        }
        return null;
    }

    @PostConstruct
    public void initialize(Composite parent, @Optional IProcessMethod processMethod, @Optional File editorInput) {
        DataCategory[] categories;
        if (processMethod == null && editorInput == null) {
            throw new IllegalStateException("no method file and no processmethod specified for part");
        }
        if (editorInput != null) {
            this.currentProcessMethod = (IProcessMethod)Adapters.adapt((Object)editorInput, IProcessMethod.class);
            this.processMethodFile = editorInput;
            if (this.currentProcessMethod == null) {
                throw new RuntimeException("can't read file " + this.processMethodFile);
            }
        } else {
            this.currentProcessMethod = processMethod;
        }
        if ((categories = this.currentProcessMethod.getDataCategories().toArray(new DataCategory[0])) == null || categories.length == 0) {
            categories = new DataCategory[]{DataCategory.CSD, DataCategory.MSD, DataCategory.WSD};
        }
        this.part.setLabel(String.valueOf(this.part.getLabel()) + " " + Arrays.asList(categories));
        this.extendedMethodUI = new ExtendedMethodUI(parent, 0, this.processSupplierContext, categories);
        this.extendedMethodUI.setModificationHandler(this);
        this.extendedMethodUI.setProcessMethod(this.currentProcessMethod);
        this.extendedMethodUI.setHeaderToolbarVisible(this.processMethodFile == null);
    }

    public void setDirty(boolean dirty) {
        this.part.setDirty(this.processMethodFile == null || !this.extendedMethodUI.getProcessMethod().contentEquals(this.currentProcessMethod, true));
    }
}

