/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.ui.editors.IChromatogramEditor;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.editors.ChromatogramEditor;
import org.eclipse.chemclipse.xxd.process.files.SupplierFileIdentifier;
import org.eclipse.chemclipse.xxd.process.support.ProcessTypeSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ChromatogramEditor3x
extends EditorPart
implements IChromatogramEditor {
    private static final String EDITOR_ID = "org.eclipse.chemclipse.ux.extension.xxd.ui.editors.chromatogramEditor3x";
    private ChromatogramEditor chromatogramEditor;
    private final MPart part = PartSupport.get3xEditorPart((String)"org.eclipse.chemclipse.ux.extension.xxd.ui.editors.chromatogramEditor3x", (EPartService)ModelSupportAddon.getPartService(), (EModelService)ModelSupportAddon.getModelService(), (MApplication)ModelSupportAddon.getApplication());
    private final MDirtyable dirtyable = new MDirtyable(){
        private boolean value = false;

        public void setDirty(boolean value) {
            this.value = value;
        }

        public boolean isDirty() {
            return this.value;
        }
    };

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        DataType dataType = this.getDataType();
        if (dataType != null) {
            this.chromatogramEditor = new ChromatogramEditor(dataType, parent, this.part, this.dirtyable, DisplayUtils.getShell(), (ProcessSupplierContext)new ProcessTypeSupport());
        } else {
            Label label = new Label(parent, 0);
            label.setText("Sorry, the chromatogram couldn't be displayed.");
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        String fileName = input.getName();
        fileName = fileName.substring(0, fileName.length() - 4);
        this.setPartName(fileName);
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("The file could't be loaded.");
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)input;
        File file = fileEditorInput.getFile().getLocation().toFile();
        this.part.setLabel("Chromatogram");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("File", file.getAbsolutePath());
        map.put("Batch", false);
        this.part.setObject(map);
        this.part.setTooltip("Chromatogram from Project Explorer");
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.chromatogramEditor != null) {
            this.chromatogramEditor.save();
        }
    }

    public void doSaveAs() {
        if (this.chromatogramEditor != null) {
            this.chromatogramEditor.saveAs();
        }
    }

    public boolean isDirty() {
        return this.dirtyable.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
        if (this.chromatogramEditor != null) {
            this.chromatogramEditor.setFocus();
        }
    }

    private DataType getDataType() {
        DataType dataType = null;
        Object object = this.part.getObject();
        if (object instanceof Map) {
            Map map = (Map)object;
            String path = (String)map.get("File");
            File file = new File(path);
            if (this.isMatch(file, (ISupplierFileIdentifier)new SupplierFileIdentifier(DataType.MSD))) {
                dataType = DataType.MSD;
            } else if (this.isMatch(file, (ISupplierFileIdentifier)new SupplierFileIdentifier(DataType.CSD))) {
                dataType = DataType.CSD;
            } else if (this.isMatch(file, (ISupplierFileIdentifier)new SupplierFileIdentifier(DataType.WSD))) {
                dataType = DataType.WSD;
            }
        }
        return dataType;
    }

    private boolean isMatch(File file, ISupplierFileIdentifier supplierFileIdentifier) {
        boolean isMatch = false;
        if (supplierFileIdentifier != null && file != null && file.exists() && supplierFileIdentifier.isSupplierFile(file) && supplierFileIdentifier.isMatchMagicNumber(file)) {
            isMatch = true;
        }
        return isMatch;
    }

    public boolean saveAs() {
        return false;
    }

    public IChromatogramSelection getChromatogramSelection() {
        if (this.chromatogramEditor != null) {
            return this.chromatogramEditor.getChromatogramSelection();
        }
        return null;
    }
}

