/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.charts;

import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChartSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;

public class CalibrationChart
extends LineChart {
    private static final String TITLE_X_AXIS_CONCENTRATION = "Concentration";
    private static final String TITLE_Y_AXIS_RESPONSE = "Response";
    private static final String TITLE_Y_AXIS_RELATIVE_RESPONSE = "Relative Response [%]";
    private ChartSupport chartSupport = new ChartSupport(Activator.getDefault().getPreferenceStore());

    public CalibrationChart() {
        this.initialize();
    }

    public CalibrationChart(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void setConcentrationLabel(String concentrationUnit) {
        IChartSettings chartSettings = this.getChartSettings();
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        String title = TITLE_X_AXIS_CONCENTRATION;
        if (concentrationUnit != null && !"".equals(concentrationUnit)) {
            title = String.valueOf(title) + " [" + concentrationUnit + "]";
        }
        primaryAxisSettingsX.setTitle(title);
        this.applySettings(chartSettings);
    }

    private void initialize() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(false);
        chartSettings.setVerticalSliderVisible(false);
        chartSettings.getRangeRestriction().setZeroX(true);
        chartSettings.getRangeRestriction().setZeroY(true);
        chartSettings.setCreateMenu(true);
        this.modifyAxes(true);
    }

    public void modifyAxes(boolean applySettings) {
        this.modifyXAxisConcentration();
        this.modifyYAxisResponse();
        this.modifyYAxisRelativeResponse();
        if (applySettings) {
            IChartSettings chartSettings = this.getChartSettings();
            this.applySettings(chartSettings);
        }
    }

    private void modifyXAxisConcentration() {
        IChartSettings chartSettings = this.getChartSettings();
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle(TITLE_X_AXIS_CONCENTRATION);
        String positionNode = "positionXAxisConcentrationCalibration";
        String pattern = "0.0##";
        String colorNode = "colorXAxisConcentrationCalibration";
        String gridLineStyleNode = "gridlineStyleXAxisConcentrationCalibration";
        String gridColorNode = "gridlineColorXAxisConcentrationCalibration";
        boolean isShowAxis = this.chartSupport.getBoolean("showXAxisConcentrationCalibration");
        this.chartSupport.setAxisSettings((IAxisSettings)primaryAxisSettingsX, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
        primaryAxisSettingsX.setVisible(isShowAxis);
    }

    private void modifyYAxisResponse() {
        IChartSettings chartSettings = this.getChartSettings();
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle(TITLE_Y_AXIS_RESPONSE);
        String positionNode = "positionYAxisResponseCalibration";
        String pattern = "0.0#E0";
        String colorNode = "colorYAxisResponseCalibration";
        String gridLineStyleNode = "gridlineStyleYAxisResponseCalibration";
        String gridColorNode = "gridlineColorYAxisResponseCalibration";
        boolean isShowAxis = this.chartSupport.getBoolean("showYAxisResponseCalibration");
        this.chartSupport.setAxisSettings((IAxisSettings)primaryAxisSettingsY, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
        primaryAxisSettingsY.setVisible(isShowAxis);
    }

    private void modifyYAxisRelativeResponse() {
        IChartSettings chartSettings = this.getChartSettings();
        ISecondaryAxisSettings axisSettings = this.chartSupport.getSecondaryAxisSettingsY(TITLE_Y_AXIS_RELATIVE_RESPONSE, chartSettings);
        String positionNode = "positionYAxisRelativeResponseCalibration";
        String pattern = "0.00";
        String colorNode = "colorYAxisRelativeResponseCalibration";
        String gridLineStyleNode = "gridlineStyleYAxisRelativeResponseCalibration";
        String gridColorNode = "gridlineColorYAxisRelativeResponseCalibration";
        boolean isShowAxis = this.chartSupport.getBoolean("showYAxisRelativeResponseCalibration");
        if (isShowAxis) {
            if (axisSettings == null) {
                SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings(TITLE_Y_AXIS_RELATIVE_RESPONSE, (IAxisScaleConverter)new PercentageConverter(512, true));
                this.chartSupport.setAxisSettings((IAxisSettings)secondaryAxisSettingsY, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
            } else {
                this.chartSupport.setAxisSettings((IAxisSettings)axisSettings, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                axisSettings.setVisible(true);
            }
        } else if (axisSettings != null) {
            axisSettings.setVisible(false);
        }
    }
}

