/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractFilterAction<FilterType extends Filter<?>, ResultType>
extends Action {
    protected FilterType filter;
    private Consumer<ResultType> resultConsumer;

    public AbstractFilterAction(FilterType filter, Consumer<ResultType> resultConsumer) {
        this.filter = filter;
        this.resultConsumer = resultConsumer;
        this.setToolTipText(filter.getDescription());
        this.setId(filter.getID());
        this.setText(filter.getName());
        this.setImageDescriptor((ImageDescriptor)Adapters.adapt(filter, ImageDescriptor.class));
    }

    public void runWithEvent(Event event) {
        Widget widget = event.widget;
        Object shell = widget instanceof MenuItem ? ((MenuItem)widget).getParent().getShell() : (widget instanceof Control ? ((Control)widget).getShell() : null);
        this.executeAction((Shell)shell);
    }

    public void executeAction(Shell shell) {
        final DefaultProcessingResult consumer = new DefaultProcessingResult();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(shell);
        monitorDialog.setCancelable(true);
        try {
            monitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Object result = AbstractFilterAction.this.computeResult((MessageConsumer)consumer, monitor);
                    if (result != null) {
                        AbstractFilterAction.this.resultConsumer.accept(result);
                    }
                }
            });
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)consumer);
        }
        catch (InvocationTargetException e) {
            ProcessingInfoViewSupport.updateProcessingInfoError((String)this.filter.getName(), (String)"Processing failed", (Throwable)e.getTargetException());
        }
        catch (InterruptedException e) {
            return;
        }
    }

    protected abstract ResultType computeResult(MessageConsumer var1, IProgressMonitor var2);
}

