/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.runnables;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io.JobReader;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.BatchProcessJob;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ImportRunnable
implements IRunnableWithProgress {
    private File file;
    private BatchProcessJob batchProcessJob = null;

    public ImportRunnable(File file) {
        this.file = file;
    }

    public BatchProcessJob getBatchProcessJob() {
        return this.batchProcessJob;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            JobReader reader = new JobReader();
            this.batchProcessJob = reader.read(this.file, monitor);
        }
        catch (FileNotFoundException e) {
            throw new InterruptedException("The file " + this.file.getPath() + " couldn't be found.");
        }
        catch (FileIsNotReadableException e) {
            throw new InterruptedException("The file " + this.file.getPath() + " is not readable.");
        }
        catch (FileIsEmptyException e) {
            throw new InterruptedException("The file " + this.file.getPath() + " is empty.");
        }
        catch (IOException e) {
            throw new InterruptedException("An I/O error has occured using the file " + this.file.getPath());
        }
    }
}

