/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.filter.impl.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.filter.Activator;
import org.eclipse.chemclipse.chromatogram.filter.impl.settings.FilterSettingsSelection;
import org.eclipse.chemclipse.chromatogram.filter.impl.settings.PeakTargetsToReferencesSettings;
import org.eclipse.chemclipse.chromatogram.filter.impl.settings.ScanTargetsToPeakSettings;
import org.eclipse.chemclipse.chromatogram.filter.impl.settings.ScanTargetsToReferencesSettings;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final double MIN_RETENTION_TIME_MINUTES = 0.0;
    public static final double MAX_RETENTION_TIME_MINUTES = Double.MAX_VALUE;
    public static final String P_START_RETENTION_TIME_MINUTES = "startRetentionTimeMinutes";
    public static final double DEF_START_RETENTION_TIME_MINUTES = 1.0;
    public static final String P_STOP_RETENTION_TIME_MINUTES = "stopRetentionTimeMinutes";
    public static final double DEF_STOP_RETENTION_TIME_MINUTES = 10.0;
    public static final String P_STTP_TRANSFER_CLOSEST_SCAN = "scanTargetsToPeakTransferClosestScan";
    public static final boolean DEF_STTP_TRANSFER_CLOSEST_SCAN = false;
    public static final String P_STTP_USE_BEST_TARGET_ONLY = "scanTargetsToPeakUseBestTargetOnly";
    public static final boolean DEF_STTP_USE_BEST_TARGET_ONLY = false;
    public static final String P_PTTR_USE_BEST_TARGET_ONLY = "peakTargetsToReferencesUseBestTargetOnly";
    public static final boolean DEF_PTTR_USE_BEST_TARGET_ONLY = false;
    public static final String P_DELTA_RETENTION_TIME_MINUTES = "peakTargetsToReferencesDeltaRetentionTimeMinutes";
    public static final double DEF_DELTA_RETENTION_TIME_MINUTES = 0.1;
    public static final String P_STTR_USE_BEST_TARGET_ONLY = "scanTargetsToReferencesUseBestTargetOnly";
    public static final boolean DEF_STTR_USE_BEST_TARGET_ONLY = false;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_START_RETENTION_TIME_MINUTES, Double.toString(1.0));
        defaultValues.put(P_STOP_RETENTION_TIME_MINUTES, Double.toString(10.0));
        defaultValues.put(P_STTP_TRANSFER_CLOSEST_SCAN, Boolean.toString(false));
        defaultValues.put(P_STTP_USE_BEST_TARGET_ONLY, Boolean.toString(false));
        defaultValues.put(P_PTTR_USE_BEST_TARGET_ONLY, Boolean.toString(false));
        defaultValues.put(P_DELTA_RETENTION_TIME_MINUTES, Double.toString(0.1));
        defaultValues.put(P_STTR_USE_BEST_TARGET_ONLY, Boolean.toString(false));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static FilterSettingsSelection getFilterSettingsSelection() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        FilterSettingsSelection filterSettings = new FilterSettingsSelection();
        filterSettings.setStartRetentionTimeMinutes(preferences.getDouble(P_START_RETENTION_TIME_MINUTES, 1.0));
        filterSettings.setStopRetentionTimeMinutes(preferences.getDouble(P_STOP_RETENTION_TIME_MINUTES, 10.0));
        return filterSettings;
    }

    public static ScanTargetsToPeakSettings getScanToPeakTargetTransferSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        ScanTargetsToPeakSettings settings = new ScanTargetsToPeakSettings();
        settings.setTransferClosestScan(preferences.getBoolean(P_STTP_TRANSFER_CLOSEST_SCAN, false));
        settings.setUseBestTargetOnly(preferences.getBoolean(P_STTP_USE_BEST_TARGET_ONLY, false));
        return settings;
    }

    public static PeakTargetsToReferencesSettings getPeaksToReferencesTransferSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        PeakTargetsToReferencesSettings settings = new PeakTargetsToReferencesSettings();
        settings.setUseBestTargetOnly(preferences.getBoolean(P_PTTR_USE_BEST_TARGET_ONLY, false));
        settings.setDeltaRetentionTime(preferences.getDouble(P_DELTA_RETENTION_TIME_MINUTES, 0.1));
        return settings;
    }

    public static ScanTargetsToReferencesSettings getScansToReferencesTransferSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        ScanTargetsToReferencesSettings settings = new ScanTargetsToReferencesSettings();
        settings.setUseBestTargetOnly(preferences.getBoolean(P_STTR_USE_BEST_TARGET_ONLY, false));
        return settings;
    }
}

