/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.filter.impl;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.impl.AbstractTransferFilter;
import org.eclipse.chemclipse.chromatogram.filter.impl.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.filter.impl.settings.PeakTargetsToReferencesSettings;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.TargetTransferSupport;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakTargetsToReferencesFilter
extends AbstractTransferFilter {
    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages() && chromatogramFilterSettings instanceof PeakTargetsToReferencesSettings) {
            PeakTargetsToReferencesSettings settings = (PeakTargetsToReferencesSettings)chromatogramFilterSettings;
            this.transferTargets(chromatogramSelection, settings);
            processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "Targets transfered successfully."));
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        PeakTargetsToReferencesSettings settings = PreferenceSupplier.getPeaksToReferencesTransferSettings();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)settings, monitor);
    }

    private void transferTargets(IChromatogramSelection chromatogramSelection, PeakTargetsToReferencesSettings settings) {
        TargetTransferSupport targetTransferSupport = new TargetTransferSupport();
        List referencedChromatograms = chromatogramSelection.getChromatogram().getReferencedChromatograms();
        if (referencedChromatograms.size() > 0) {
            int retentionTimeDelta = (int)(settings.getDeltaRetentionTime() * 60000.0);
            boolean useBestTargetOnly = settings.isUseBestTargetOnly();
            List<? extends IPeak> peaksSource = this.extractPeaks(chromatogramSelection);
            for (IChromatogram referencedChromatogram : referencedChromatograms) {
                List<? extends IPeak> peaksSink = this.extractPeaks(referencedChromatogram);
                targetTransferSupport.transferPeakTargets(peaksSource, peaksSink, retentionTimeDelta, useBestTargetOnly);
            }
        }
    }
}

