/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.filter.core.chromatogram;

import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.IChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.xwc.ExtractedSingleWavelengthSignalExtractor;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignal;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignals;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractChromatogramSignalFilter
extends AbstractChromatogramFilter
implements IChromatogramFilter {
    protected abstract IChromatogramFilterResult applyFilter(ITotalScanSignals var1, IChromatogramFilterSettings var2, IProgressMonitor var3);

    protected abstract IChromatogramFilterResult applyFilter(ITotalScanSignals var1, IProgressMonitor var2);

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages()) {
            IChromatogramFilterResult chromatogramFilterResult = this.process(chromatogramSelection, chromatogramFilterSettings, monitor);
            processingInfo.setProcessingResult((Object)chromatogramFilterResult);
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validateChromatogramSelection(chromatogramSelection);
        if (!processingInfo.hasErrorMessages()) {
            IChromatogramFilterResult chromatogramFilterResult = this.process(chromatogramSelection, null, monitor);
            processingInfo.setProcessingResult((Object)chromatogramFilterResult);
        }
        return processingInfo;
    }

    private IChromatogramFilterResult process(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            return this.process((IChromatogramSelectionMSD)chromatogramSelection, chromatogramFilterSettings, monitor);
        }
        if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
            return this.process((IChromatogramSelectionCSD)chromatogramSelection, chromatogramFilterSettings, monitor);
        }
        if (chromatogramSelection instanceof IChromatogramSelectionWSD) {
            return this.process((IChromatogramSelectionWSD)chromatogramSelection, chromatogramFilterSettings, monitor);
        }
        throw new UnsupportedOperationException("Class " + chromatogramSelection.getClass().getName() + " is not supported");
    }

    private IChromatogramFilterResult process(IChromatogramSelectionCSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IChromatogramCSD chromatogramCSD = chromatogramSelection.getChromatogramCSD();
        TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor((IChromatogram)chromatogramCSD);
        ITotalScanSignals totalSignals = totalScanSignalExtractor.getTotalScanSignals((IChromatogramSelection)chromatogramSelection, false);
        IChromatogramFilterResult chromatogramFilterResult = this.filterProcess(totalSignals, chromatogramFilterSettings, monitor);
        if (chromatogramFilterResult.getResultStatus().equals((Object)ResultStatus.OK)) {
            for (Integer scan : totalSignals) {
                IScanCSD scanCSD = chromatogramCSD.getSupplierScan(scan.intValue());
                ITotalScanSignal totalscanSignal = totalSignals.getTotalScanSignal(scan.intValue());
                scanCSD.adjustTotalSignal(totalscanSignal.getTotalSignal());
            }
        }
        return chromatogramFilterResult;
    }

    public IChromatogramFilterResult process(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IChromatogramMSD chromatogramMSD = chromatogramSelection.getChromatogramMSD();
        TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor((IChromatogram)chromatogramMSD);
        ITotalScanSignals totalSignals = totalScanSignalExtractor.getTotalScanSignals((IChromatogramSelection)chromatogramSelection, true);
        IChromatogramFilterResult chromatogramFilterResult = this.filterProcess(totalSignals, chromatogramFilterSettings, monitor);
        totalSignals.setNegativeTotalSignalsToZero();
        Iterator itScan = totalSignals.iterator();
        if (chromatogramFilterResult.getResultStatus().equals((Object)ResultStatus.OK)) {
            while (itScan.hasNext()) {
                Integer scan = (Integer)itScan.next();
                IVendorMassSpectrum scanMSD = chromatogramMSD.getSupplierScan(scan.intValue());
                ITotalScanSignal totalscanSignal = totalSignals.getTotalScanSignal(scan.intValue());
                scanMSD.adjustTotalSignal(totalscanSignal.getTotalSignal());
            }
        }
        return chromatogramFilterResult;
    }

    private IChromatogramFilterResult process(IChromatogramSelectionWSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IChromatogramWSD chromatogramWSD = chromatogramSelection.getChromatogramWSD();
        ExtractedSingleWavelengthSignalExtractor extractor = new ExtractedSingleWavelengthSignalExtractor(chromatogramWSD, false);
        List extractedSingleWavelengthSignals = extractor.getExtractedWavelengthSignals(chromatogramSelection);
        IChromatogramFilterResult chromatogramFilterResultFinal = null;
        for (IExtractedSingleWavelengthSignals totalSignals : extractedSingleWavelengthSignals) {
            IChromatogramFilterResult chromatogramFilterResult = this.filterProcess((ITotalScanSignals)totalSignals, chromatogramFilterSettings, monitor);
            if (!chromatogramFilterResult.getResultStatus().equals((Object)ResultStatus.OK)) {
                return chromatogramFilterResult;
            }
            chromatogramFilterResultFinal = chromatogramFilterResult;
        }
        for (IExtractedSingleWavelengthSignals totalSignals : extractedSingleWavelengthSignals) {
            Iterator itScan = totalSignals.iterator();
            double wavelength = totalSignals.getWavelength();
            while (itScan.hasNext()) {
                int scan = (Integer)itScan.next();
                IScanSignalWSD scanSignal = (IScanSignalWSD)chromatogramWSD.getSupplierScan(scan).getScanSignal(wavelength).get();
                IExtractedSingleWavelengthSignal totalSignal = totalSignals.getTotalScanSignal(scan);
                scanSignal.setAbundance(totalSignal.getTotalSignal());
            }
        }
        return chromatogramFilterResultFinal;
    }

    public IChromatogramFilterResult filterProcess(ITotalScanSignals totalScanSignals, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        if (chromatogramFilterSettings == null) {
            return this.applyFilter(totalScanSignals, monitor);
        }
        return this.applyFilter(totalScanSignals, chromatogramFilterSettings, monitor);
    }
}

