/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards;

import java.util.List;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class QuantitationDocumentPageESTD
extends WizardPage {
    private List<String> peakTargetNames;
    private IQuantitationDatabase quantitationDatabase;
    protected Button buttonMerge;
    protected Combo comboQuantitationCompoundNames;
    protected Text textConcentrationMerge;
    protected Button buttonCreate;
    protected Combo comboPeakTargetNames;
    protected Text textConcentrationCreate;
    protected Text textConcentrationUnitCreate;
    protected Text textChemicalClassCreate;
    private Label labelConcentrationUnitMerge;
    private Label label1;
    private Label label2;
    private Label label3;

    protected QuantitationDocumentPageESTD(String pageName, List<String> peakTargetNames, IQuantitationDatabase quantitationDatabase) {
        super(pageName);
        this.setTitle("Quantitation Support");
        this.setDescription("Create a quantitation component.");
        this.peakTargetNames = peakTargetNames;
        this.quantitationDatabase = quantitationDatabase;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createMergePeakControls(composite);
        this.createAddPeakControls(composite);
        this.enableMergePeakControls();
        this.setControl((Control)composite);
    }

    private void createMergePeakControls(Composite parent) {
        this.buttonMerge = this.createButton(parent, "Add the peak to an existing Quantitation Component", false);
        this.comboQuantitationCompoundNames = this.createComboCompoundNames(parent);
        this.textConcentrationMerge = this.createText(parent);
        this.labelConcentrationUnitMerge = this.createLabel(parent, "", 2);
    }

    private void createAddPeakControls(Composite parent) {
        this.buttonCreate = this.createButton(parent, "Create a new Quantitation Component", false);
        this.comboPeakTargetNames = this.createComboTargetNames(parent);
        this.textConcentrationCreate = this.createText(parent);
        this.label1 = this.createLabel(parent, "Concentration", 1);
        this.textConcentrationUnitCreate = this.createText(parent);
        this.label2 = this.createLabel(parent, "Concentration Unit (e.g. mg/ml)", 1);
        this.textChemicalClassCreate = this.createText(parent);
        this.label3 = this.createLabel(parent, "Chemical Class", 1);
    }

    private Button createButton(Composite parent, String text, boolean selection) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setSelection(selection);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuantitationDocumentPageESTD.this.enableMergePeakControls();
            }
        });
        return button;
    }

    private Combo createComboCompoundNames(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        if (this.quantitationDatabase != null) {
            List quantitationCompoundNames = this.quantitationDatabase.getCompoundNames();
            combo.setItems(quantitationCompoundNames.toArray(new String[quantitationCompoundNames.size()]));
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QuantitationDocumentPageESTD.this.quantitationDatabase != null) {
                    String name = combo.getText();
                    IQuantitationCompound quantitationCompound = QuantitationDocumentPageESTD.this.quantitationDatabase.getQuantitationCompound(name);
                    if (quantitationCompound != null) {
                        String concentrationUnit = quantitationCompound.getConcentrationUnit();
                        QuantitationDocumentPageESTD.this.labelConcentrationUnitMerge.setText(concentrationUnit);
                    }
                }
            }
        });
        return combo;
    }

    private Combo createComboTargetNames(Composite parent) {
        Combo combo = new Combo(parent, 0);
        if (this.peakTargetNames.size() > 0) {
            combo.setItems(this.peakTargetNames.toArray(new String[this.peakTargetNames.size()]));
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    private Label createLabel(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        return label;
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void enableMergePeakControls() {
        boolean enable = this.buttonMerge.getSelection();
        this.modifyMergeControls(enable);
        this.modifyAddControls(!enable);
    }

    private void modifyMergeControls(boolean enabled) {
        this.comboQuantitationCompoundNames.setEnabled(enabled);
        this.textConcentrationMerge.setEnabled(enabled);
        this.labelConcentrationUnitMerge.setEnabled(enabled);
    }

    private void modifyAddControls(boolean enabled) {
        this.comboPeakTargetNames.setEnabled(enabled);
        this.textConcentrationCreate.setEnabled(enabled);
        this.textConcentrationUnitCreate.setEnabled(enabled);
        this.textChemicalClassCreate.setEnabled(enabled);
        this.label1.setEnabled(enabled);
        this.label2.setEnabled(enabled);
        this.label3.setEnabled(enabled);
    }
}

