/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards;

import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationPeakMSD;
import org.eclipse.chemclipse.xxd.model.quantitation.QuantitationCompound;

public class QuantitationCompoundSupport {
    public IQuantitationCompound create(IPeak peak, String name, double concentration, String concentrationUnit, String chemicalClass) {
        IPeakModel peakModel = peak.getPeakModel();
        IScan scan = peakModel.getPeakMaximum();
        int retentionTime = scan.getRetentionTime();
        float retentionIndex = scan.getRetentionIndex();
        QuantitationCompound quantitationCompound = new QuantitationCompound(name, concentrationUnit, retentionTime);
        quantitationCompound.setChemicalClass(chemicalClass);
        IRetentionTimeWindow retentionTimeWindow = quantitationCompound.getRetentionTimeWindow();
        if (retentionTime > 0) {
            retentionTimeWindow.setAllowedNegativeDeviation((float)((int)(PreferenceSupplier.getRetentionTimeNegativeDeviation() * 60000.0)));
            retentionTimeWindow.setAllowedPositiveDeviation((float)((int)(PreferenceSupplier.getRetentionTimePositiveDeviation() * 60000.0)));
        }
        IRetentionIndexWindow retentionIndexWindow = quantitationCompound.getRetentionIndexWindow();
        retentionIndexWindow.setRetentionIndex(retentionIndex);
        if (retentionIndex > 0.0f) {
            retentionIndexWindow.setAllowedNegativeDeviation(PreferenceSupplier.getRetentionIndexNegativeDeviation());
            retentionIndexWindow.setAllowedPositiveDeviation(PreferenceSupplier.getRetentionIndexPositiveDeviation());
        }
        QuantitationPeakMSD quantitationPeakMSD = new QuantitationPeakMSD((IPeakMSD)peak, concentration, concentrationUnit);
        quantitationCompound.getQuantitationPeaks().add(quantitationPeakMSD);
        quantitationCompound.setQuantitationSignalTIC();
        return quantitationCompound;
    }

    public void merge(IQuantitationDatabase quantitationDatabase, IPeak peak, String name, double concentration) {
        IQuantitationCompound quantitationCompound = quantitationDatabase.getQuantitationCompound(name);
        if (quantitationCompound != null) {
            QuantitationPeakMSD quantitationPeakMSD = new QuantitationPeakMSD((IPeakMSD)peak, concentration, quantitationCompound.getConcentrationUnit());
            quantitationCompound.getQuantitationPeaks().add(quantitationPeakMSD);
        }
    }
}

