/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.QuantitationCompoundSupport;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.QuantitationDocumentPageESTD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationPeakMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AddPeakWizardESTD
extends Wizard {
    private static final Logger logger = Logger.getLogger(AddPeakWizardESTD.class);
    private QuantitationDocumentPageESTD quantitationDocumentPage;
    private IQuantitationDatabase quantitationDatabase;
    private IChromatogramPeakMSD chromatogramPeakMSD;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public AddPeakWizardESTD(IQuantitationDatabase quantitationDatabase, IChromatogramPeakMSD chromatogramPeakMSD) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Add Peak (ESTD)");
        this.quantitationDatabase = quantitationDatabase;
        this.chromatogramPeakMSD = chromatogramPeakMSD;
    }

    public void addPages() {
        List<String> peakTargetNames = this.getPeakTargetNames((IPeak)this.chromatogramPeakMSD);
        this.quantitationDocumentPage = new QuantitationDocumentPageESTD("Quantitation Document", peakTargetNames, this.quantitationDatabase);
        this.addPage((IWizardPage)this.quantitationDocumentPage);
    }

    public boolean performFinish() {
        this.removeErrorMessage();
        if (this.quantitationDatabase == null) {
            this.showErrorMessage("Please select a valid quantitation database.");
            return false;
        }
        if (this.quantitationDocumentPage.buttonMerge.getSelection()) {
            return this.checkAndMergeQuantitationDocument();
        }
        return this.checkAndCreateNewQuantitationDocument();
    }

    private boolean checkAndMergeQuantitationDocument() {
        String name = this.quantitationDocumentPage.comboQuantitationCompoundNames.getText().trim();
        IQuantitationCompound quantitationCompoundMSD = this.quantitationDatabase.getQuantitationCompound(name);
        if (quantitationCompoundMSD != null) {
            block5: {
                double concentration = this.decimalFormat.parse(this.quantitationDocumentPage.textConcentrationMerge.getText().trim()).doubleValue();
                if (!(concentration > 0.0)) break block5;
                String concentrationUnit = quantitationCompoundMSD.getConcentrationUnit();
                QuantitationPeakMSD quantitationPeakMSD = new QuantitationPeakMSD((IPeakMSD)this.chromatogramPeakMSD, concentration, concentrationUnit);
                quantitationCompoundMSD.getQuantitationPeaks().add(quantitationPeakMSD);
                return true;
            }
            try {
                this.showErrorMessage("Please select a valid concentration.");
            }
            catch (ParseException e) {
                logger.warn((Object)e);
                this.showErrorMessage("Please type in a valid concentration.");
            }
        } else {
            this.showErrorMessage("An existing quantitation compound must be selected.");
        }
        return false;
    }

    private boolean checkAndCreateNewQuantitationDocument() {
        String name = this.quantitationDocumentPage.comboPeakTargetNames.getText().trim();
        if (name == null || name.equals("")) {
            this.showErrorMessage("Please select a quantitation compound name.");
        } else {
            boolean documentStillExists = this.quantitationDatabase.containsQuantitationCompund(name);
            if (documentStillExists) {
                this.showErrorMessage("The quantitation compound still exists in the database.");
            } else {
                String concentrationUnit = this.quantitationDocumentPage.textConcentrationUnitCreate.getText().trim();
                if (concentrationUnit == null || concentrationUnit.equals("")) {
                    this.showErrorMessage("Please select a concentration unit.");
                } else {
                    block9: {
                        double concentration = this.decimalFormat.parse(this.quantitationDocumentPage.textConcentrationCreate.getText().trim()).doubleValue();
                        if (!(concentration >= 0.0)) break block9;
                        QuantitationCompoundSupport quantitationCompoundSupport = new QuantitationCompoundSupport();
                        String chemicalClass = this.quantitationDocumentPage.textChemicalClassCreate.getText().trim();
                        IQuantitationCompound quantitationCompound = quantitationCompoundSupport.create((IPeak)this.chromatogramPeakMSD, name, concentration, concentrationUnit, chemicalClass);
                        this.quantitationDatabase.add((Object)quantitationCompound);
                        return true;
                    }
                    try {
                        this.showErrorMessage("Please select a valid concentration.");
                    }
                    catch (ParseException e1) {
                        logger.warn((Object)e1);
                        this.showErrorMessage("Please type in a valid concentration.");
                    }
                }
            }
        }
        return false;
    }

    private void showErrorMessage(String message) {
        this.quantitationDocumentPage.setErrorMessage(message);
    }

    private void removeErrorMessage() {
        this.quantitationDocumentPage.setErrorMessage(null);
    }

    private List<String> getPeakTargetNames(IPeak peak) {
        Set peakTargets;
        ArrayList<String> peakTargetNames = new ArrayList<String>();
        if (peak != null && (peakTargets = peak.getTargets()).size() > 0) {
            for (IIdentificationTarget peakTarget : peakTargets) {
                if (!(peakTarget instanceof IIdentificationTarget)) continue;
                IIdentificationTarget peakIdentificationEntry = peakTarget;
                String name = peakIdentificationEntry.getLibraryInformation().getName();
                peakTargetNames.add(name);
            }
        }
        return peakTargetNames;
    }
}

