/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.internal.xygraph.undo.MovingAnnotationCommand;
import org.eclipse.nebula.visualization.internal.xygraph.undo.MovingAnnotationLabelCommand;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProviderListener;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IAnnotationLabelProvider;
import org.eclipse.nebula.visualization.xygraph.figures.IAnnotationListener;
import org.eclipse.nebula.visualization.xygraph.figures.IAxisListener;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.Preferences;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Annotation
extends Figure
implements IAxisListener,
IDataProviderListener {
    private IAnnotationLabelProvider labelProvider = null;
    protected Axis xAxis;
    protected Axis yAxis;
    private String name;
    private FontData fontData;
    private CursorLineStyle cursorLineStyle = CursorLineStyle.NONE;
    private Point currentPosition;
    protected double xValue;
    protected double yValue;
    protected Trace trace;
    protected ISample currentSnappedSample;
    private boolean showName = true;
    private boolean showSampleInfo = true;
    private boolean showPosition = true;
    private Color annotationColor = null;
    private RGB annotationColorRGB = null;
    private Label infoLabel;
    private double dx = 40.0;
    private double dy = -40.0;
    private double x0;
    private double y0;
    private boolean knowX0Y0 = false;
    private boolean infoLabelArmed = false;
    private Pointer pointer;
    private Polyline vLine;
    private Polyline hLine;
    private IXYGraph xyGraph;
    private static final int POINT_SIZE = 6;
    private static final int CURSOR_LINE_LENGTH = 3;
    private static final int ARROW_LINE_LENGTH = 12;
    protected boolean pointerDragged;
    private List<IAnnotationListener> listeners;

    public Annotation(String name, Trace trace) {
        this(name, trace.getXAxis(), trace.getYAxis());
        this.trace = trace;
        trace.getDataProvider().addDataProviderListener(this);
    }

    public Annotation(String name, Axis xAxis, Axis yAxis) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.name = name;
        this.trace = null;
        this.infoLabel = new Label();
        this.infoLabel.setOpaque(false);
        this.infoLabel.setCursor(Cursors.SIZEALL);
        this.add((IFigure)this.infoLabel);
        InfoLabelDragger infoLabelDragger = new InfoLabelDragger();
        this.infoLabel.addMouseMotionListener((MouseMotionListener)infoLabelDragger);
        this.infoLabel.addMouseListener((MouseListener)infoLabelDragger);
        this.pointer = new Pointer();
        this.add((IFigure)this.pointer);
        this.updateToDefaultPosition();
        xAxis.addListener(this);
        yAxis.addListener(this);
    }

    public synchronized void addAnnotationListener(IAnnotationListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<IAnnotationListener>();
        }
        this.listeners.add(listener);
    }

    private void fireAnnotationMoved(double oldX, double oldY, double newX, double newY) {
        if (this.listeners == null) {
            return;
        }
        for (IAnnotationListener listener : this.listeners) {
            listener.annotationMoved(oldX, oldY, newX, newY);
        }
    }

    public boolean containsPoint(int x, int y) {
        return this.infoLabel.containsPoint(x, y) || this.pointer.containsPoint(x, y) || this.vLine != null && this.vLine.containsPoint(x, y) || this.hLine != null && this.hLine.containsPoint(x, y);
    }

    protected void layout() {
        super.layout();
        if (this.trace != null && this.currentSnappedSample == null && !this.pointerDragged) {
            this.updateToDefaultPosition();
        }
        Dimension size = this.infoLabel.getPreferredSize();
        this.updateX0Y0Fromdxdy(size);
        Rectangle infoBounds = new Rectangle((int)((double)this.currentPosition.x + this.x0 - (double)size.width / 2.0), (int)((double)this.currentPosition.y + this.y0 - (double)size.height / 2.0), size.width, size.height);
        this.infoLabel.setBounds(infoBounds);
        this.pointer.setBounds(new Rectangle(this.currentPosition.x - 6, this.currentPosition.y - 6, 12, 12));
        switch (this.cursorLineStyle) {
            case NONE: {
                break;
            }
            case LEFT_RIGHT: 
            case FOUR_DIRECTIONS: {
                this.hLine.setPoints(new PointList(new int[]{this.xAxis.getValuePosition(this.xAxis.getRange().getLower(), false), this.currentPosition.y, this.xAxis.getValuePosition(this.xAxis.getRange().getUpper(), false), this.currentPosition.y}));
                if (this.cursorLineStyle != CursorLineStyle.FOUR_DIRECTIONS) break;
            }
            case UP_DOWN: {
                this.vLine.setPoints(new PointList(new int[]{this.currentPosition.x, this.yAxis.getValuePosition(this.yAxis.getRange().getUpper(), false), this.currentPosition.x, this.yAxis.getValuePosition(this.yAxis.getRange().getLower(), false)}));
                break;
            }
        }
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.trace != null && this.currentSnappedSample == null && !this.pointerDragged) {
            this.updateToDefaultPosition();
        }
        if (Preferences.useAdvancedGraphics()) {
            graphics.setAntialias(1);
        }
        Color tempColor = this.annotationColor == null ? this.yAxis.getForegroundColor() : this.annotationColor;
        this.infoLabel.setForegroundColor(tempColor);
        this.pointer.setForegroundColor(tempColor);
        if (this.vLine != null) {
            this.vLine.setForegroundColor(tempColor);
        }
        if (this.hLine != null) {
            this.hLine.setForegroundColor(tempColor);
        }
        graphics.setForegroundColor(tempColor);
        if (this.infoLabelArmed) {
            graphics.drawRectangle(this.infoLabel.getBounds());
        }
        if (this.showName || this.showPosition || this.showSampleInfo) {
            graphics.drawLine(this.currentPosition.x + (int)this.dx, this.currentPosition.y + (int)this.dy, this.currentPosition.x, this.currentPosition.y);
            int x1 = (int)(12.0 * Math.cos(Math.atan(-this.dy / this.dx) - 0.3490658503988659));
            int y1 = (int)(12.0 * Math.sin(Math.atan(-this.dy / this.dx) - 0.3490658503988659));
            if (this.dx < 0.0) {
                x1 = -x1;
                y1 = -y1;
            }
            graphics.drawLine(this.currentPosition.x + x1, this.currentPosition.y - y1, this.currentPosition.x, this.currentPosition.y);
            x1 = (int)(12.0 * Math.cos(Math.atan(-this.dy / this.dx) + 0.3490658503988659));
            y1 = (int)(12.0 * Math.sin(Math.atan(-this.dy / this.dx) + 0.3490658503988659));
            if (this.dx < 0.0) {
                x1 = -x1;
                y1 = -y1;
            }
            graphics.drawLine(this.currentPosition.x + x1, this.currentPosition.y - y1, this.currentPosition.x, this.currentPosition.y);
        }
        switch (this.cursorLineStyle) {
            case NONE: {
                graphics.drawLine(this.currentPosition.x - 3, this.currentPosition.y, this.currentPosition.x - 3 - 3, this.currentPosition.y);
                graphics.drawLine(this.currentPosition.x + 3, this.currentPosition.y, this.currentPosition.x + 3 + 3, this.currentPosition.y);
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y - 3, this.currentPosition.x, this.currentPosition.y - 3 - 3);
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y + 3, this.currentPosition.x, this.currentPosition.y + 3 + 3);
                break;
            }
            case LEFT_RIGHT: 
            case FOUR_DIRECTIONS: {
                graphics.drawLine(this.currentPosition.x - 3, this.currentPosition.y, this.xAxis.getValuePosition(this.xAxis.getRange().getLower(), false), this.currentPosition.y);
                graphics.drawLine(this.currentPosition.x + 3, this.currentPosition.y, this.xAxis.getValuePosition(this.xAxis.getRange().getUpper(), false), this.currentPosition.y);
                if (this.cursorLineStyle != CursorLineStyle.FOUR_DIRECTIONS) break;
            }
            case UP_DOWN: {
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y - 3, this.currentPosition.x, this.yAxis.getValuePosition(this.yAxis.getRange().getUpper(), false));
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y + 3, this.currentPosition.x, this.yAxis.getValuePosition(this.yAxis.getRange().getLower(), false));
                break;
            }
        }
    }

    public void updateX0Y0Fromdxdy(Dimension size) {
        if (!this.knowX0Y0) {
            this.knowX0Y0 = true;
            int h = size.height;
            int w = size.width;
            if (this.dy != 0.0) {
                this.y0 = this.dy - (double)h / 2.0;
                this.x0 = this.dx / this.dy * this.y0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)w / 2.0, this.x0 + (double)w / 2.0).inRange(this.dx)) {
                    return;
                }
                this.y0 = this.dy + (double)h / 2.0;
                this.x0 = this.dx / this.dy * this.y0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)w / 2.0, this.x0 + (double)w / 2.0).inRange(this.dx)) {
                    return;
                }
            }
            if (this.dx != 0.0) {
                this.x0 = this.dx + (double)w / 2.0;
                this.y0 = this.dy / this.dx * this.x0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)h / 2.0, this.y0 + (double)h / 2.0).inRange(this.dy)) {
                    return;
                }
                this.x0 = this.dx - (double)w / 2.0;
                this.y0 = this.dy / this.dx * this.x0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)h / 2.0, this.y0 + (double)h / 2.0).inRange(this.dy)) {
                    return;
                }
            }
        } else {
            return;
        }
    }

    private void updatedxdyFromX0Y0() {
        Dimension size = this.infoLabel.getPreferredSize();
        int h = size.height;
        int w = size.width;
        if (this.y0 != 0.0) {
            this.dy = this.y0 + (double)h / 2.0;
            this.dx = this.x0 * this.dy / this.y0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)w / 2.0, this.x0 + (double)w / 2.0).inRange(this.dx)) {
                return;
            }
            this.dy = this.y0 - (double)h / 2.0;
            this.dx = this.x0 * this.dy / this.y0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)w / 2.0, this.x0 + (double)w / 2.0).inRange(this.dx)) {
                return;
            }
        } else {
            this.dy = 0.0;
        }
        if (this.x0 != 0.0) {
            this.dx = this.x0 - (double)size.width / 2.0;
            this.dy = this.y0 * this.dx / this.x0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)h / 2.0, this.y0 + (double)h / 2.0).inRange(this.dy)) {
                return;
            }
            this.dx = this.x0 + (double)size.width / 2.0;
            this.dy = this.y0 * this.dx / this.x0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)h / 2.0, this.y0 + (double)h / 2.0).inRange(this.dy)) {
                return;
            }
        } else {
            this.dx = 0.0;
        }
    }

    protected void updateToDefaultPosition() {
        double oldX = this.xValue;
        double oldY = this.yValue;
        if (this.trace != null && this.trace.getHotSampleList().size() > 0) {
            this.currentSnappedSample = this.trace.getHotSampleList().get(this.trace.getHotSampleList().size() / 2);
            this.currentPosition = new Point(this.xAxis.getValuePosition(this.currentSnappedSample.getXValue(), false), this.yAxis.getValuePosition(this.currentSnappedSample.getYValue(), false));
            this.xValue = this.currentSnappedSample.getXValue();
            this.yValue = this.currentSnappedSample.getYValue();
        } else {
            this.currentSnappedSample = null;
            this.xValue = this.xAxis.isLogScaleEnabled() ? Math.pow(10.0, (Math.log10(this.xAxis.getRange().getLower()) + Math.log10(this.xAxis.getRange().getUpper())) / 2.0) : (this.xAxis.getRange().getLower() + this.xAxis.getRange().getUpper()) / 2.0;
            this.yValue = this.yAxis.isLogScaleEnabled() ? Math.pow(10.0, (Math.log10(this.yAxis.getRange().getLower()) + Math.log10(this.yAxis.getRange().getUpper())) / 2.0) : (this.yAxis.getRange().getLower() + this.yAxis.getRange().getUpper()) / 2.0;
            this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        }
        this.updateInfoLabelText(true);
        if (this.xValue != oldX || this.yValue != oldY) {
            this.revalidate();
        }
        this.fireAnnotationMoved(oldX, oldY, this.xValue, this.yValue);
    }

    public void setValues(double x, double y) {
        double oldX = this.xValue;
        double oldY = this.yValue;
        this.xValue = x;
        this.yValue = y;
        this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        this.updateInfoLabelText(true);
        this.revalidate();
        if (oldX != this.xValue || oldY != this.yValue) {
            this.fireAnnotationMoved(oldX, oldY, this.xValue, this.yValue);
        }
    }

    private void updateInfoLabelText(boolean updateX0Y0) {
        String info = null;
        if (this.labelProvider != null) {
            info = this.labelProvider.getInfoText(this.xValue, this.yValue, this.showName, this.showSampleInfo, this.showPosition);
        }
        if (info == null) {
            info = "";
            if (this.showName) {
                info = this.name;
            }
            if (this.showSampleInfo && this.currentSnappedSample != null && !this.currentSnappedSample.getInfo().equals("")) {
                info = String.valueOf(info) + "\n" + this.currentSnappedSample.getInfo();
            }
            if (this.showPosition) {
                info = String.valueOf(info) + "\n(" + this.xAxis.format(this.xValue) + ", " + (Double.isNaN(this.yValue) ? "NaN" : this.yAxis.format(this.yValue)) + ")";
            }
        }
        this.infoLabel.setText(info);
        this.knowX0Y0 = !updateX0Y0;
    }

    private void updateInfoLabelText() {
        this.updateInfoLabelText(true);
    }

    public void setXAxis(Axis axis) {
        if (this.xAxis == axis) {
            return;
        }
        this.xAxis = axis;
        this.updateToDefaultPosition();
        this.revalidate();
        this.repaint();
    }

    public void setYAxis(Axis axis) {
        if (this.yAxis == axis) {
            return;
        }
        this.yAxis = axis;
        this.updateToDefaultPosition();
        this.revalidate();
        this.repaint();
    }

    public void setName(String name) {
        this.name = name;
        this.updateInfoLabelText();
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (f != null) {
            this.fontData = this.getFont().getFontData()[0];
        }
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public void setTrace(Trace trace) {
        if (this.trace == trace) {
            return;
        }
        this.xAxis = trace.getXAxis();
        this.yAxis = trace.getYAxis();
        if (!this.isFree() && this.trace != trace) {
            this.trace.getDataProvider().removeDataProviderListener(this);
        }
        if (this.isFree() || this.trace != trace) {
            this.trace = trace;
            this.updateToDefaultPosition();
        }
        this.trace = trace;
        trace.getDataProvider().addDataProviderListener(this);
        this.repaint();
    }

    public void setFree(Axis xAxis, Axis yAxis) {
        if (this.trace != null) {
            this.trace.getDataProvider().removeDataProviderListener(this);
            this.trace = null;
            this.updateToDefaultPosition();
        }
        this.setXAxis(xAxis);
        this.setYAxis(yAxis);
        this.revalidate();
        this.repaint();
    }

    public boolean isFree() {
        return this.trace == null;
    }

    public void setShowName(boolean showName) {
        this.showName = showName;
        this.updateInfoLabelText();
    }

    public void setShowSampleInfo(boolean showSampleInfo) {
        this.showSampleInfo = showSampleInfo;
        this.updateInfoLabelText();
    }

    public void setShowPosition(boolean showPosition) {
        this.showPosition = showPosition;
        this.updateInfoLabelText();
    }

    public void setAnnotationColor(Color annotationColor) {
        this.annotationColor = annotationColor;
        if (annotationColor != null) {
            this.annotationColorRGB = annotationColor.getRGB();
        }
        this.infoLabel.setForegroundColor(annotationColor);
        this.pointer.setForegroundColor(annotationColor);
    }

    public void setAnnotationFont(Font annotationFont) {
        this.infoLabel.setFont(annotationFont);
    }

    public Font getAnnotationFont() {
        return this.infoLabel.getFont();
    }

    public void setCursorLineStyle(CursorLineStyle cursorLineStyle) {
        AnnotationDragger annotationDragger;
        this.cursorLineStyle = cursorLineStyle;
        if ((cursorLineStyle == CursorLineStyle.UP_DOWN || cursorLineStyle == CursorLineStyle.FOUR_DIRECTIONS) && this.vLine == null) {
            this.vLine = new Polyline();
            this.vLine.setCursor(Cursors.SIZEWE);
            annotationDragger = new AnnotationDragger(true, false);
            this.vLine.addMouseListener((MouseListener)annotationDragger);
            this.vLine.addMouseMotionListener((MouseMotionListener)annotationDragger);
            this.vLine.setTolerance(3);
            this.add((IFigure)this.vLine, 0);
        }
        if ((cursorLineStyle == CursorLineStyle.LEFT_RIGHT || cursorLineStyle == CursorLineStyle.FOUR_DIRECTIONS) && this.hLine == null) {
            this.hLine = new Polyline();
            this.hLine.setCursor(Cursors.SIZENS);
            annotationDragger = new AnnotationDragger(false, true);
            this.hLine.addMouseListener((MouseListener)annotationDragger);
            this.hLine.addMouseMotionListener((MouseMotionListener)annotationDragger);
            this.hLine.setTolerance(3);
            this.add((IFigure)this.hLine, 0);
        }
        if (cursorLineStyle == CursorLineStyle.UP_DOWN && this.hLine != null) {
            this.remove((IFigure)this.hLine);
            this.hLine = null;
        }
        if (cursorLineStyle == CursorLineStyle.LEFT_RIGHT && this.vLine != null) {
            this.remove((IFigure)this.vLine);
            this.vLine = null;
        }
    }

    public void setCurrentPosition(Point currentPosition, boolean keepLabelPosition, boolean calcValueFromPosition) {
        if (keepLabelPosition) {
            int deltaX = this.currentPosition.x - currentPosition.x;
            int deltaY = this.currentPosition.y - currentPosition.y;
            this.x0 += (double)deltaX;
            this.y0 += (double)deltaY;
            this.knowX0Y0 = true;
            this.updatedxdyFromX0Y0();
        }
        this.currentPosition = currentPosition;
        if (calcValueFromPosition) {
            double oldX = this.xValue;
            double oldY = this.yValue;
            this.xValue = this.xAxis.getPositionValue(currentPosition.x, false);
            this.yValue = this.yAxis.getPositionValue(currentPosition.y, false);
            this.fireAnnotationMoved(oldX, oldY, this.xValue, this.yValue);
        }
        this.updateInfoLabelText(keepLabelPosition);
        this.revalidate();
        this.repaint();
    }

    public void setCurrentPosition(Point currentPosition, boolean keepLabelPosition) {
        this.setCurrentPosition(currentPosition, keepLabelPosition, true);
    }

    public void setCurrentSnappedSample(ISample currentSnappedSample, boolean keepLabelPosition) {
        if (!this.trace.getHotSampleList().contains(currentSnappedSample)) {
            this.updateToDefaultPosition();
        } else {
            this.currentSnappedSample = currentSnappedSample;
            Point newPosition = new Point(this.xAxis.getValuePosition(currentSnappedSample.getXValue(), false), this.yAxis.getValuePosition(currentSnappedSample.getYValue(), false));
            double oldX = this.xValue;
            double oldY = this.yValue;
            this.xValue = currentSnappedSample.getXValue();
            this.yValue = currentSnappedSample.getYValue();
            if (Double.isNaN(currentSnappedSample.getXPlusError())) {
                this.yValue = Double.NaN;
            }
            this.setCurrentPosition(newPosition, keepLabelPosition, false);
            this.fireAnnotationMoved(oldX, oldY, this.xValue, this.yValue);
        }
        this.repaint();
    }

    @Override
    public void axisRevalidated(Axis axis) {
        this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        this.updateInfoLabelText();
        if (this.getParent() != null) {
            this.layout();
        }
    }

    @Override
    public void axisRangeChanged(Axis axis, Range old_range, Range new_range) {
    }

    @Override
    public void dataChanged(IDataProvider dataProvider) {
        if (this.trace == null) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Annotation.this.trace.getHotSampleList().contains(Annotation.this.currentSnappedSample)) {
                    double oldX = Annotation.this.xValue;
                    double oldY = Annotation.this.yValue;
                    if (Annotation.this.yValue != Annotation.this.currentSnappedSample.getYValue()) {
                        Annotation.this.yValue = Annotation.this.currentSnappedSample.getYValue();
                    }
                    if (Annotation.this.xValue != Annotation.this.currentSnappedSample.getXValue()) {
                        Annotation.this.xValue = Annotation.this.currentSnappedSample.getXValue();
                    }
                    Annotation.this.currentPosition = new Point(Annotation.this.xAxis.getValuePosition(Annotation.this.xValue, false), Annotation.this.yAxis.getValuePosition(Annotation.this.yValue, false));
                    Annotation.this.fireAnnotationMoved(oldX, oldY, Annotation.this.xValue, Annotation.this.yValue);
                } else if (Annotation.this.trace.getHotSampleList().size() > 0) {
                    Annotation.this.updateToDefaultPosition();
                    Annotation.this.pointerDragged = false;
                }
            }
        });
    }

    public void setXYGraph(IXYGraph xyGraph) {
        this.xyGraph = xyGraph;
    }

    public void setdxdy(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
        this.knowX0Y0 = false;
        this.repaint();
    }

    public void setLocation(double x, double y) {
        this.xValue = x;
        this.yValue = y;
        this.repaint();
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public String getName() {
        return this.name;
    }

    public double getXValue() {
        return this.xValue;
    }

    public double getYValue() {
        return this.yValue;
    }

    public CursorLineStyle getCursorLineStyle() {
        return this.cursorLineStyle;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public boolean isShowSampleInfo() {
        return this.showSampleInfo;
    }

    public boolean isShowPosition() {
        return this.showPosition;
    }

    public Color getAnnotationColor() {
        return this.annotationColor;
    }

    public IAnnotationLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(IAnnotationLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    @Override
    public void axisForegroundColorChanged(Axis axis, Color oldColor, Color newColor) {
    }

    @Override
    public void axisTitleChanged(Axis axis, String oldTitle, String newTitle) {
    }

    @Override
    public void axisAutoScaleChanged(Axis axis, boolean oldAutoScale, boolean newAutoScale) {
    }

    @Override
    public void axisLogScaleChanged(Axis axis, boolean old, boolean logScale) {
    }

    public RGB getAnnotationColorRGB() {
        return this.annotationColorRGB;
    }

    public void toFront() {
        IFigure par = this.getParent();
        if (par != null) {
            par.remove((IFigure)this);
            int end = par.getChildren() != null ? par.getChildren().size() : 0;
            par.add((IFigure)this, end);
        }
    }

    private class AnnotationDragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        private MovingAnnotationCommand command;
        private boolean horizontalMoveable;
        private boolean verticalMoveable;

        public AnnotationDragger(boolean horizontalMoveable, boolean verticalMoveable) {
            this.horizontalMoveable = horizontalMoveable;
            this.verticalMoveable = verticalMoveable;
        }

        public void mouseDragged(MouseEvent me) {
            Point mouseLocation = new Point(this.horizontalMoveable ? me.getLocation().x : ((Annotation)Annotation.this).currentPosition.x, this.verticalMoveable ? me.getLocation().y : ((Annotation)Annotation.this).currentPosition.y);
            if (Annotation.this.trace == null) {
                Annotation.this.setCurrentPosition(mouseLocation, me.getState() == 786432);
            } else {
                ISample tempSample = null;
                double minD = Double.POSITIVE_INFINITY;
                for (ISample s : Annotation.this.trace.getHotSampleList()) {
                    double d = Math.sqrt(Math.pow(Annotation.this.xAxis.getValuePosition(s.getXValue(), false) - mouseLocation.x, 2.0) + Math.pow(Annotation.this.yAxis.getValuePosition(s.getYValue(), false) - mouseLocation.y, 2.0));
                    if (!(minD > d)) continue;
                    minD = d;
                    tempSample = s;
                }
                if (tempSample != null && Annotation.this.currentSnappedSample != tempSample) {
                    Annotation.this.setCurrentSnappedSample(tempSample, me.getState() == 786432);
                } else if (tempSample == null) {
                    Annotation.this.setCurrentPosition(mouseLocation, me.getState() == 786432);
                    Annotation.this.pointerDragged = true;
                }
            }
            me.consume();
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            this.command = new MovingAnnotationCommand(Annotation.this);
            if (Annotation.this.isFree()) {
                this.command.setBeforeMovePosition(Annotation.this.currentPosition);
            } else {
                this.command.setBeforeMoveSnappedSample(Annotation.this.currentSnappedSample);
            }
            this.command.setBeforeDxDy(Annotation.this.dx, Annotation.this.dy);
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            if (this.command != null) {
                if (Annotation.this.isFree()) {
                    this.command.setAfterMovePosition(Annotation.this.currentPosition);
                } else {
                    this.command.setAfterMoveSnappedSample(Annotation.this.currentSnappedSample);
                }
                this.command.setAfterDxDy(Annotation.this.dx, Annotation.this.dy);
                Annotation.this.xyGraph.getOperationsManager().addCommand(this.command);
            }
        }
    }

    public static enum CursorLineStyle {
        NONE(0, "None"),
        UP_DOWN(1, "Up&Down"),
        LEFT_RIGHT(2, "Left&Right"),
        FOUR_DIRECTIONS(3, "Four Directions");

        private int index;
        private String description;

        private CursorLineStyle(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] sv = new String[CursorLineStyle.values().length];
            int i = 0;
            CursorLineStyle[] cursorLineStyleArray = CursorLineStyle.values();
            int n = cursorLineStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                CursorLineStyle p = cursorLineStyleArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }

        public int getIndex() {
            return this.index;
        }
    }

    class InfoLabelDragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        private MovingAnnotationLabelCommand command;

        InfoLabelDragger() {
        }

        public void mouseDragged(MouseEvent me) {
            Annotation.this.x0 = me.getLocation().x - ((Annotation)Annotation.this).currentPosition.x;
            Annotation.this.y0 = me.getLocation().y - ((Annotation)Annotation.this).currentPosition.y;
            Annotation.this.knowX0Y0 = true;
            Annotation.this.updatedxdyFromX0Y0();
            Annotation.this.revalidate();
            Annotation.this.repaint();
            me.consume();
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            this.command = new MovingAnnotationLabelCommand(Annotation.this);
            this.command.setBeforeMovingDxDy(Annotation.this.dx, Annotation.this.dy);
            Annotation.this.infoLabelArmed = true;
            Annotation.this.revalidate();
            Annotation.this.repaint();
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            this.command.setAfterMovingDxDy(Annotation.this.dx, Annotation.this.dy);
            Annotation.this.xyGraph.getOperationsManager().addCommand(this.command);
            Annotation.this.infoLabelArmed = false;
            Annotation.this.revalidate();
            Annotation.this.repaint();
            me.consume();
        }
    }

    class Pointer
    extends Figure {
        public Pointer() {
            this.setCursor(Cursors.CROSS);
            AnnotationDragger dragger = new AnnotationDragger(true, true);
            this.addMouseMotionListener((MouseMotionListener)dragger);
            this.addMouseListener(dragger);
        }

        protected void paintClientArea(Graphics graphics) {
            super.paintClientArea(graphics);
            if (Preferences.useAdvancedGraphics()) {
                graphics.setAntialias(1);
            }
            Rectangle clientArea = this.getClientArea().getCopy().shrink(3, 3);
            graphics.drawLine(clientArea.x, clientArea.y, clientArea.x + clientArea.width, clientArea.y + clientArea.height);
            graphics.drawLine(clientArea.x + clientArea.width, clientArea.y, clientArea.x, clientArea.y + clientArea.height);
        }
    }
}

