/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.ui.fieldeditors;

import java.io.File;
import java.util.Map;
import org.eclipse.chemclipse.converter.model.SeparationColumnMapping;
import org.eclipse.chemclipse.converter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.converter.ui.swt.ColumExtractorTable;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColumnExtractorFieldEditor
extends FieldEditor {
    private static final String ADD = "Add";
    private static final String ADD_TOOLTIP = "Add a new keyword";
    private static final String REMOVE = "Remove";
    private static final String REMOVE_TOOLTIP = "Remove the selected keyword(s)";
    private static final String REMOVE_ALL = "Remove All";
    private static final String REMOVE_ALL_TOOLTIP = "Remove All Keywords";
    private static final String IMPORT = "Import";
    private static final String EXPORT = "Export";
    private static final String IMPORT_TITLE = "Import Keywords";
    private static final String EXPORT_TITLE = "Export Keywords";
    private static final String DIALOG_TITLE = "Keywords(s)";
    private static final String MESSAGE_ADD = "You can create a new keyword here.";
    private static final String MESSAGE_REMOVE = "Do you want to delete the selected keyword(s)?";
    private static final String MESSAGE_REMOVE_ALL = "Do you want to delete all keyword(s)?";
    private static final String MESSAGE_EXPORT_SUCCESSFUL = "Keywords have been exported successfully.";
    private static final String MESSAGE_EXPORT_FAILED = "Failed to export the keywords.";
    private static final String FILTER_EXTENSION = "*.txt";
    private static final String FILTER_NAME = "Separation Column Mapping (*.txt)";
    private static final String FILE_NAME = "SeparationColumnMapping.txt";
    private static final String CATEGORY = "Column Mapping";
    private static final String DELETE = "Delete";
    private static final int NUMBER_COLUMNS = 2;
    private Composite composite;
    private ColumExtractorTable extendedTable;
    private SeparationColumnMapping mapping = new SeparationColumnMapping();

    public ColumnExtractorFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.composite.setLayoutData((Object)gridData);
        this.createTableSection(this.composite);
        this.createButtonGroup(this.composite);
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns >= 2) {
            GridData gridData = (GridData)this.composite.getLayoutData();
            gridData.horizontalSpan = numColumns - 1;
            gridData.grabExcessHorizontalSpace = true;
        }
    }

    protected void doLoad() {
        String entries = this.getPreferenceStore().getString(this.getPreferenceName());
        this.mapping.load(entries);
        this.setTableViewerInput();
    }

    protected void doLoadDefault() {
        String entries = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.mapping.loadDefault(entries);
        this.setTableViewerInput();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.mapping.save());
    }

    private void createTableSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        this.extendedTable = new ColumExtractorTable(composite, 68354);
        Shell shell = this.extendedTable.getTable().getShell();
        ITableSettings tableSettings = this.extendedTable.getTableSettings();
        this.addDeleteMenuEntry(shell, tableSettings);
        this.addKeyEventProcessors(shell, tableSettings);
        this.extendedTable.applySettings(tableSettings);
        this.setTableViewerInput();
    }

    private void createButtonGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.setButtonLayoutData(this.createButtonAdd(composite));
        this.setButtonLayoutData(this.createButtonRemove(composite));
        this.setButtonLayoutData(this.createButtonRemoveAll(composite));
        this.setButtonLayoutData(this.createButtonImport(composite));
        this.setButtonLayoutData(this.createButtonExport(composite));
    }

    private Button createButtonAdd(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setText(ADD);
        button.setToolTipText(ADD_TOOLTIP);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String item;
                InputDialog dialog = new InputDialog(button.getShell(), ColumnExtractorFieldEditor.DIALOG_TITLE, ColumnExtractorFieldEditor.MESSAGE_ADD, "DB5", new IInputValidator(){

                    public String isValid(String newText) {
                        if ("".equals(newText)) {
                            return "Please type in a keyword.";
                        }
                        if (newText.contains("|")) {
                            return "The keyword must not contain the following character: '|'";
                        }
                        if (newText.contains(";")) {
                            return "The keyword must not contain the following character: ';'";
                        }
                        if (ColumnExtractorFieldEditor.this.mapping.containsKey((Object)newText)) {
                            return "The keyword already exists.";
                        }
                        return null;
                    }
                });
                if (dialog.open() == 0 && !"".equals(item = dialog.getValue().trim()) && !ColumnExtractorFieldEditor.this.mapping.keySet().contains(item)) {
                    ColumnExtractorFieldEditor.this.mapping.put((Object)item, (Object)"DEFAULT");
                    ColumnExtractorFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonRemove(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(REMOVE);
        button.setToolTipText(REMOVE_TOOLTIP);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnExtractorFieldEditor.this.deleteItems(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonRemoveAll(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setText(REMOVE_ALL);
        button.setToolTipText(REMOVE_ALL_TOOLTIP);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)button.getShell(), (String)ColumnExtractorFieldEditor.DIALOG_TITLE, (String)ColumnExtractorFieldEditor.MESSAGE_REMOVE_ALL)) {
                    ColumnExtractorFieldEditor.this.mapping.clear();
                    ColumnExtractorFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonImport(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(IMPORT);
        button.setToolTipText(IMPORT_TITLE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 8);
                fileDialog.setText(ColumnExtractorFieldEditor.IMPORT_TITLE);
                fileDialog.setFilterExtensions(new String[]{ColumnExtractorFieldEditor.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{ColumnExtractorFieldEditor.FILTER_NAME});
                fileDialog.setFilterPath(PreferenceSupplier.getListPathImport());
                String path = fileDialog.open();
                if (path != null) {
                    PreferenceSupplier.setListPathImport((String)fileDialog.getFilterPath());
                    File file = new File(path);
                    ColumnExtractorFieldEditor.this.mapping.importItems(file);
                    ColumnExtractorFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonExport(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setText(EXPORT);
        button.setToolTipText(EXPORT_TITLE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 8192);
                fileDialog.setOverwrite(true);
                fileDialog.setText(ColumnExtractorFieldEditor.EXPORT_TITLE);
                fileDialog.setFilterExtensions(new String[]{ColumnExtractorFieldEditor.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{ColumnExtractorFieldEditor.FILTER_NAME});
                fileDialog.setFileName(ColumnExtractorFieldEditor.FILE_NAME);
                fileDialog.setFilterPath(PreferenceSupplier.getListPathExport());
                String path = fileDialog.open();
                if (path != null) {
                    PreferenceSupplier.setListPathExport((String)fileDialog.getFilterPath());
                    File file = new File(path);
                    if (ColumnExtractorFieldEditor.this.mapping.exportItems(file)) {
                        MessageDialog.openInformation((Shell)button.getShell(), (String)ColumnExtractorFieldEditor.EXPORT_TITLE, (String)ColumnExtractorFieldEditor.MESSAGE_EXPORT_SUCCESSFUL);
                    } else {
                        MessageDialog.openWarning((Shell)button.getShell(), (String)ColumnExtractorFieldEditor.EXPORT_TITLE, (String)ColumnExtractorFieldEditor.MESSAGE_EXPORT_FAILED);
                    }
                }
            }
        });
        return button;
    }

    private void addDeleteMenuEntry(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return ColumnExtractorFieldEditor.DELETE;
            }

            public String getCategory() {
                return ColumnExtractorFieldEditor.CATEGORY;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ColumnExtractorFieldEditor.this.deleteItems(shell);
            }
        });
    }

    private void addKeyEventProcessors(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addKeyEventProcessor(new IKeyEventProcessor(){

            public void handleEvent(ExtendedTableViewer extendedTableViewer, KeyEvent e) {
                if (e.keyCode == 127) {
                    ColumnExtractorFieldEditor.this.deleteItems(shell);
                }
            }
        });
    }

    private void deleteItems(Shell shell) {
        if (MessageDialog.openQuestion((Shell)shell, (String)DIALOG_TITLE, (String)MESSAGE_REMOVE)) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.extendedTable.getSelection();
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Map.Entry) {
                    this.mapping.remove(((Map.Entry)object).getKey());
                }
                ++n2;
            }
            this.setTableViewerInput();
        }
    }

    private void setTableViewerInput() {
        this.extendedTable.setInput(this.mapping);
    }
}

