/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.internal.support.SeriesComparator;
import org.eclipse.swtchart.extensions.internal.support.SeriesEditingSupport;
import org.eclipse.swtchart.extensions.internal.support.SeriesFilter;
import org.eclipse.swtchart.extensions.internal.support.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.internal.support.SeriesMapper;

public class SeriesListUI
extends TableViewer {
    private static final String[] TITLES = SeriesLabelProvider.TITLES;
    private static final int[] BOUNDS = SeriesLabelProvider.BOUNDS;
    private static final String COLUMN_DELIMITER = " ";
    private ILabelProvider labelProvider = new SeriesLabelProvider();
    private IContentProvider contentProvider = ArrayContentProvider.getInstance();
    private SeriesComparator comparator = new SeriesComparator();
    private SeriesFilter filter = new SeriesFilter();
    private List<TableViewerColumn> columns = new ArrayList<TableViewerColumn>();
    private ScrollableChart scrollableChart;
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();

    public SeriesListUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.filter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    public void setScrollableChart(ScrollableChart scrollableChart) {
        this.scrollableChart = scrollableChart;
    }

    public void refresh() {
        Object input = this.getInput();
        if (input instanceof ISeries[] && this.scrollableChart != null) {
            ISeries[] seriesArray = (ISeries[])input;
            SeriesMapper seriesMapper = new SeriesMapper(this.scrollableChart.getBaseChart());
            seriesMapper.mapSettings(seriesArray);
        }
        if (this.scrollableChart != null) {
            this.scrollableChart.redraw();
        }
        super.refresh();
    }

    private void createControl() {
        this.createColumns(TITLES, BOUNDS);
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider(this.contentProvider);
        this.setComparator(this.comparator);
        this.setFilters(new ViewerFilter[]{this.filter});
        this.setCellColorAndEditSupport();
        this.setColumnOrder(this.getTable());
    }

    private void createColumns(String[] titles, int[] bounds) {
        Table table = this.getTable();
        table.setRedraw(false);
        table.clearAll();
        while (table.getColumnCount() > 0) {
            table.getColumns()[0].dispose();
        }
        table.setRedraw(true);
        this.refresh();
        if (this.getLabelProvider() != null) {
            int i = 0;
            while (i < titles.length) {
                String title = titles[i];
                TableViewerColumn tableViewerColumn = this.createTableColumn(title, bounds[i]);
                TableColumn tableColumn = tableViewerColumn.getColumn();
                tableColumn.addSelectionListener((SelectionListener)this.createSelectionAdapter(tableColumn, i));
                this.columns.add(tableViewerColumn);
                ++i;
            }
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private SelectionAdapter createSelectionAdapter(TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeriesListUI.this.comparator.setColumn(index);
                int direction = SeriesListUI.this.comparator.getDirection();
                SeriesListUI.this.getTable().setSortDirection(direction);
                SeriesListUI.this.refresh();
            }
        };
        return selectionAdapter;
    }

    private TableViewerColumn createTableColumn(String title, int width) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(title);
        tableColumn.setWidth(width);
        tableColumn.setResizable(true);
        tableColumn.setMoveable(true);
        tableColumn.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                String columnOrder = SeriesListUI.this.getColumnOrder(SeriesListUI.this.getTable());
                if (SeriesListUI.this.preferenceStore != null) {
                    SeriesListUI.this.preferenceStore.setValue("legendColumnOrder", columnOrder);
                }
            }
        });
        return tableViewerColumn;
    }

    private void setCellColorAndEditSupport() {
        for (TableViewerColumn tableViewerColumn : this.columns) {
            String title;
            switch (title = tableViewerColumn.getColumn().getText()) {
                case "Color": {
                    this.setColorColumnProvider(tableViewerColumn);
                    break;
                }
                case "ID": {
                    this.setIdColumnProvider(tableViewerColumn);
                }
            }
            tableViewerColumn.setEditingSupport((EditingSupport)new SeriesEditingSupport(this, title));
        }
    }

    private void setColorColumnProvider(TableViewerColumn tableViewerColumn) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell != null) {
                    Object object = cell.getElement();
                    Color color = SeriesLabelProvider.getColor(object);
                    cell.setBackground(color);
                    cell.setText("");
                    super.update(cell);
                }
            }
        });
    }

    private void setIdColumnProvider(TableViewerColumn tableViewerColumn) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object object;
                if (cell != null && (object = cell.getItem().getData()) instanceof ISeries) {
                    ISeries series = (ISeries)object;
                    String text = series.getId();
                    cell.setForeground(ResourceSupport.getColor(125, 125, 125));
                    cell.setText(text);
                    super.update(cell);
                }
            }
        });
    }

    private void setColumnOrder(Table table) {
        if (this.preferenceStore != null) {
            try {
                String columnOrder = this.preferenceStore.getString("legendColumnOrder");
                int[] columns = this.convertColumnOrder(columnOrder);
                table.setColumnOrder(columns);
            }
            catch (IllegalArgumentException | SWTException throwable) {
                // empty catch block
            }
        }
    }

    private int[] convertColumnOrder(String columnOrder) {
        String[] values = columnOrder.split(COLUMN_DELIMITER);
        int size = values.length;
        int[] columns = new int[size];
        int i = 0;
        while (i < size) {
            try {
                columns[i] = Integer.parseInt(values[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return columns;
    }

    private String getColumnOrder(Table table) {
        return this.convertColumnOrder(table.getColumnOrder());
    }

    private String convertColumnOrder(int[] columnOrder) {
        StringBuilder builder = new StringBuilder();
        int[] nArray = columnOrder;
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            builder.append(i);
            builder.append(COLUMN_DELIMITER);
            ++n2;
        }
        return builder.toString().trim();
    }
}

