/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.AbstractPeakDetector;
import org.eclipse.chemclipse.chromatogram.peak.detector.model.Threshold;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IDetectorSlope;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IRawPeak;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.RawPeak;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.IFirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.miscellaneous.Evaluation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BasePeakDetector
extends AbstractPeakDetector {
    protected static final float NORMALIZATION_BASE = 100000.0f;
    protected static final int CONSECUTIVE_SCAN_STEPS = 3;

    public static List<IRawPeak> getRawPeaks(IFirstDerivativeDetectorSlopes slopes, Threshold thresholdSetting, IProgressMonitor monitor) {
        double threshold;
        switch (thresholdSetting) {
            case OFF: {
                threshold = 5.0E-4;
                break;
            }
            case LOW: {
                threshold = 0.005;
                break;
            }
            case MEDIUM: {
                threshold = 0.05;
                break;
            }
            case HIGH: {
                threshold = 0.5;
                break;
            }
            default: {
                threshold = 0.005;
            }
        }
        int size = slopes.size();
        int scanOffset = slopes.getStartScan() - 1;
        ArrayList<IRawPeak> rawPeaks = new ArrayList<IRawPeak>();
        int limit = size - 3;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)limit);
        int i = 1;
        while (i <= limit) {
            int peakStop;
            int peakStart = BasePeakDetector.detectPeakStart(slopes, i, scanOffset, threshold);
            int peakMaximum = BasePeakDetector.detectPeakMaximum(slopes, peakStart, scanOffset);
            i = peakStop = BasePeakDetector.detectPeakStop(slopes, peakMaximum, scanOffset);
            RawPeak rawPeak = new RawPeak(peakStart += scanOffset, peakMaximum += scanOffset, peakStop += scanOffset);
            if (BasePeakDetector.isValidRawPeak((IRawPeak)rawPeak)) {
                rawPeaks.add((IRawPeak)rawPeak);
            }
            subMonitor.worked(1);
            ++i;
        }
        return rawPeaks;
    }

    protected ScanRange optimizeBaseline(IChromatogram<? extends IPeak> chromatogram, int startScan, int centerScan, int stopScan, IMarkedIons ions) {
        int stopScanOptimized = this.optimizeRightBaseline(chromatogram, startScan, centerScan, stopScan, ions);
        int startScanOptimized = this.optimizeLeftBaseline(chromatogram, startScan, centerScan, stopScanOptimized, ions);
        return new ScanRange(startScanOptimized, stopScanOptimized);
    }

    protected float getScanSignal(IChromatogram<? extends IPeak> chromatogram, int scanNumber, IMarkedIons ions) {
        float scanSignal = 0.0f;
        IScan scan = chromatogram.getScan(scanNumber);
        if (scan instanceof IScanMSD) {
            IScanMSD scanMSD = (IScanMSD)scan;
            scanSignal = scanMSD.getTotalSignal(ions);
        } else {
            scanSignal = scan.getTotalSignal();
        }
        return scanSignal;
    }

    private int optimizeRightBaseline(IChromatogram<? extends IPeak> chromatogram, int startScan, int centerScan, int stopScan, IMarkedIons ions) {
        Point p1 = new Point((double)this.getRetentionTime(chromatogram, startScan), (double)this.getScanSignal(chromatogram, startScan, ions));
        Point p2 = new Point((double)this.getRetentionTime(chromatogram, stopScan), (double)this.getScanSignal(chromatogram, stopScan, ions));
        LinearEquation backgroundEquation = Equations.createLinearEquation((IPoint)p1, (IPoint)p2);
        int stopScanOptimized = stopScan;
        int i = stopScan;
        while (i > centerScan) {
            int retentionTime;
            float signal = this.getScanSignal(chromatogram, i, ions);
            if ((double)signal < backgroundEquation.calculateY((double)(retentionTime = chromatogram.getScan(i).getRetentionTime()))) {
                stopScanOptimized = i;
            }
            --i;
        }
        return stopScanOptimized;
    }

    private int optimizeLeftBaseline(IChromatogram<? extends IPeak> chromatogram, int startScan, int centerScan, int stopScan, IMarkedIons ions) {
        Point p1 = new Point((double)this.getRetentionTime(chromatogram, startScan), (double)this.getScanSignal(chromatogram, startScan, ions));
        Point p2 = new Point((double)this.getRetentionTime(chromatogram, stopScan), (double)this.getScanSignal(chromatogram, stopScan, ions));
        LinearEquation backgroundEquation = Equations.createLinearEquation((IPoint)p1, (IPoint)p2);
        int startScanOptimized = startScan;
        int i = startScan;
        while (i < centerScan) {
            int retentionTime;
            float signal = this.getScanSignal(chromatogram, i, ions);
            if ((double)signal < backgroundEquation.calculateY((double)(retentionTime = chromatogram.getScan(i).getRetentionTime()))) {
                startScanOptimized = i;
                p1 = new Point((double)this.getRetentionTime(chromatogram, startScanOptimized), (double)this.getScanSignal(chromatogram, startScanOptimized, ions));
                p2 = new Point((double)this.getRetentionTime(chromatogram, stopScan), (double)this.getScanSignal(chromatogram, stopScan, ions));
                backgroundEquation = Equations.createLinearEquation((IPoint)p1, (IPoint)p2);
            }
            ++i;
        }
        return startScanOptimized;
    }

    protected int getRetentionTime(IChromatogram<? extends IPeak> chromatogram, int scanNumber) {
        return chromatogram.getScan(scanNumber).getRetentionTime();
    }

    private static boolean isValidRawPeak(IRawPeak rawPeak) {
        boolean isValid = false;
        int width = rawPeak.getStopScan() - rawPeak.getStartScan() + 1;
        if (width >= 3) {
            isValid = true;
        }
        return isValid;
    }

    private static int detectPeakStart(IFirstDerivativeDetectorSlopes slopes, int startScan, int scanOffset, double threshold) {
        int size = slopes.size();
        int peakStart = size - 1;
        double[] values = new double[3];
        int scan = startScan;
        while (scan <= size - 3) {
            IDetectorSlope slope = slopes.getDetectorSlope(scan + scanOffset);
            if (slope.getSlope() > threshold) {
                int j = 0;
                while (j < 3) {
                    values[j] = slopes.getDetectorSlope(scan + j + scanOffset).getSlope();
                    ++j;
                }
                if (Evaluation.valuesAreGreaterThanThreshold((double[])values, (double)threshold) && Evaluation.valuesAreIncreasing((double[])values)) {
                    peakStart = scan;
                    break;
                }
            }
            ++scan;
        }
        return peakStart;
    }

    private static int detectPeakMaximum(IFirstDerivativeDetectorSlopes slopes, int startScan, int scanOffset) {
        int size = slopes.size();
        int peakMaximum = startScan;
        int scan = startScan;
        while (scan <= size - 3) {
            IDetectorSlope slope = slopes.getDetectorSlope(scan + scanOffset);
            if (slope.getSlope() < 0.0) {
                peakMaximum = scan;
                break;
            }
            ++scan;
        }
        return peakMaximum;
    }

    private static int detectPeakStop(IFirstDerivativeDetectorSlopes slopes, int startScan, int scanOffset) {
        int size = slopes.size();
        int peakStop = size - 3;
        int scan = startScan;
        while (scan <= size - 3) {
            IDetectorSlope slope = slopes.getDetectorSlope(scan + scanOffset);
            if (slope.getSlope() > 0.0) {
                peakStop = scan;
                break;
            }
            ++scan;
        }
        return peakStop;
    }
}

