/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.processor;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.ISegment;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.Segment;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.SegmentAreaCalculator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;

public class ChromatogramIntegrator {
    private static final Logger logger = Logger.getLogger(ChromatogramIntegrator.class);
    private static final double CORRECTION_FACTOR_TRAPEZOID = 100.0;

    public double integrate(IChromatogramSelection chromatogramSelection) {
        double chromatogramArea = 0.0;
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        try {
            TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor(chromatogram);
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
            ITotalScanSignals totalIonSignals = totalScanSignalExtractor.getTotalScanSignals(startScan, stopScan);
            double segmentArea = 0.0;
            int scan = startScan;
            while (scan < stopScan) {
                ITotalScanSignal startSignal = totalIonSignals.getTotalScanSignal(scan);
                ITotalScanSignal stopSignal = totalIonSignals.getTotalScanSignal(scan + 1);
                if (startSignal != null && stopSignal != null) {
                    segmentArea = this.calculateArea(startSignal.getRetentionTime(), stopSignal.getRetentionTime(), startSignal.getTotalSignal(), stopSignal.getTotalSignal());
                    chromatogramArea += segmentArea;
                }
                ++scan;
            }
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        return chromatogramArea;
    }

    private double calculateArea(int startRetentionTime, int stopRetentionTime, float startAbundance, float stopAbundance) {
        double integratedArea = 0.0;
        Point psp1 = new Point((double)startRetentionTime, (double)startAbundance);
        Point psp2 = new Point((double)stopRetentionTime, (double)stopAbundance);
        Point pbp1 = new Point((double)startRetentionTime, 0.0);
        Point pbp2 = new Point((double)stopRetentionTime, 0.0);
        Segment segment = new Segment((IPoint)pbp1, (IPoint)pbp2, (IPoint)psp1, (IPoint)psp2);
        integratedArea = SegmentAreaCalculator.calculateSegmentArea((ISegment)segment) / 100.0;
        return integratedArea;
    }
}

