/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.action;

import java.util.List;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.action.ActionManagerFactory;
import org.apache.pdfbox.preflight.exception.ValidationException;

public abstract class AbstractActionManager {
    private ActionManagerFactory actionFact = null;
    private String aaKey = null;
    protected COSDictionary actionDictionnary = null;
    protected PreflightContext context = null;

    AbstractActionManager(ActionManagerFactory amFact, COSDictionary adict, PreflightContext ctx, String aaKey) {
        this.actionFact = amFact;
        this.actionDictionnary = adict;
        this.aaKey = aaKey;
        this.context = ctx;
    }

    public boolean isAdditionalAction() {
        return this.aaKey != null;
    }

    public COSDictionary getActionDictionnary() {
        return this.actionDictionnary;
    }

    public String getAdditionalActionKey() {
        return this.aaKey;
    }

    protected boolean validNextActions() throws ValidationException {
        List<AbstractActionManager> lActions = this.actionFact.getNextActions(this.context, this.actionDictionnary);
        for (AbstractActionManager nAction : lActions) {
            if (nAction.innerValid()) continue;
            return false;
        }
        return true;
    }

    public boolean valid() throws ValidationException {
        return this.valid(false);
    }

    public boolean valid(boolean additonalActionAuth) throws ValidationException {
        if (this.isAdditionalAction() && !additonalActionAuth) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.2.2", "Additional Action are forbidden"));
            return false;
        }
        if (this.innerValid()) {
            return this.validNextActions();
        }
        return true;
    }

    protected abstract boolean innerValid() throws ValidationException;
}

