/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.mediannormalizer.core;

import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramSignalFilter;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.mediannormalizer.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.mediannormalizer.settings.FilterSettings;
import org.eclipse.chemclipse.model.exceptions.CalculationException;
import org.eclipse.chemclipse.model.exceptions.NoTotalSignalStoredException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramSignalFilter {
    protected IChromatogramFilterResult applyFilter(ITotalScanSignals totalSignals, IChromatogramFilterSettings filterSettings, IProgressMonitor monitor) {
        try {
            TotalScanSignalsModifier.medianNormalize((ITotalScanSignals)totalSignals);
        }
        catch (NoTotalSignalStoredException e) {
            return new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage());
        }
        catch (CalculationException e) {
            return new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage());
        }
        return new ChromatogramFilterResult(ResultStatus.OK, "The chromatogram selection was successfully normalized.");
    }

    protected IChromatogramFilterResult applyFilter(ITotalScanSignals totalSignals, IProgressMonitor monitor) {
        FilterSettings filterSettings = PreferenceSupplier.getFilterSettings();
        return this.applyFilter(totalSignals, (IChromatogramFilterSettings)filterSettings, monitor);
    }
}

