/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.support;

import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.model.IChromatogramOutputEntry;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.processing.converter.ISupplier;

public class ConverterTypeSupportMSD {
    private static final Logger logger = Logger.getLogger(ConverterTypeSupportMSD.class);
    public static final String NOT_AVAILABLE = "n.a.";

    public String getConverterName(IChromatogramOutputEntry entry) {
        String converterName = NOT_AVAILABLE;
        try {
            ISupplier converterSupplier = ChromatogramConverterMSD.getInstance().getChromatogramConverterSupport().getSupplier(entry.getConverterId());
            converterName = converterSupplier.getFilterName();
        }
        catch (NoConverterAvailableException e) {
            logger.warn((Object)e);
        }
        return converterName;
    }
}

