/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.peak;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.peak.IPeakExportConverter;
import org.eclipse.chemclipse.msd.converter.peak.IPeakImportConverter;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterSupport;
import org.eclipse.chemclipse.msd.converter.peak.PeakSupplier;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakConverterMSD {
    private static final Logger logger = Logger.getLogger(PeakConverterMSD.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.msd.converter.peakSupplier";

    private PeakConverterMSD() {
    }

    public static IProcessingInfo<IPeaks<?>> convert(File file, String converterId, IProgressMonitor monitor) {
        IPeakImportConverter importConverter = PeakConverterMSD.getPeakImportConverter(converterId);
        if (importConverter != null) {
            return importConverter.convert(file, monitor);
        }
        return PeakConverterMSD.getNoImportConverterAvailableProcessingInfo(file);
    }

    public static IProcessingInfo convert(File file, IProgressMonitor monitor) {
        return PeakConverterMSD.getPeaks(file, monitor);
    }

    public static IProcessingInfo convert(File file, IPeaks peaks, boolean append, String converterId, IProgressMonitor monitor) {
        IPeakExportConverter exportConverter = PeakConverterMSD.getPeakExportConverter(converterId);
        IProcessingInfo<?> processingInfo = exportConverter != null ? exportConverter.convert(file, (IPeaks<? extends IPeakMSD>)peaks, append, monitor) : PeakConverterMSD.getNoExportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    private static IProcessingInfo getPeaks(File file, IProgressMonitor monitor) {
        PeakConverterSupport converterSupport = PeakConverterMSD.getPeakConverterSupport();
        try {
            List availableConverterIds = converterSupport.getAvailableConverterIds(file);
            for (String converterId : availableConverterIds) {
                IProcessingInfo<IPeaks<?>> processingInfo;
                IPeakImportConverter importConverter = PeakConverterMSD.getPeakImportConverter(converterId);
                if (importConverter == null || (processingInfo = importConverter.convert(file, monitor)).hasErrorMessages()) continue;
                try {
                    processingInfo.getProcessingResult(IPeaks.class);
                    return processingInfo;
                }
                catch (TypeCastException e) {
                    logger.warn((Object)e);
                }
            }
        }
        catch (NoConverterAvailableException e) {
            logger.warn((Object)e);
        }
        return PeakConverterMSD.getNoImportConverterAvailableProcessingInfo(file);
    }

    private static IPeakImportConverter getPeakImportConverter(String converterId) {
        IConfigurationElement element = PeakConverterMSD.getConfigurationElement(converterId);
        IPeakImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IPeakImportConverter)element.createExecutableExtension("importConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    public static IPeakExportConverter getPeakExportConverter(String converterId) {
        IConfigurationElement element = PeakConverterMSD.getConfigurationElement(converterId);
        IPeakExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IPeakExportConverter)element.createExecutableExtension("exportConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static PeakConverterSupport getPeakConverterSupport() {
        IConfigurationElement[] extensions;
        PeakConverterSupport peakConverterSupport = new PeakConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            PeakSupplier supplier = new PeakSupplier();
            supplier.setFileExtension(element.getAttribute("fileExtension"));
            supplier.setFileName(element.getAttribute("fileName"));
            supplier.setDirectoryExtension(element.getAttribute("directoryExtension"));
            if (Converter.isValid((String)supplier.getFileExtension()) && Converter.isValid((String)supplier.getFileName()) && Converter.isValid((String)supplier.getDirectoryExtension())) {
                supplier.setId(element.getAttribute("id"));
                supplier.setDescription(element.getAttribute("description"));
                supplier.setFilterName(element.getAttribute("filterName"));
                supplier.setExportable(Boolean.valueOf(element.getAttribute("isExportable")));
                supplier.setImportable(Boolean.valueOf(element.getAttribute("isImportable")));
                supplier.setMagicNumberMatcher(PeakConverterMSD.getMagicNumberMatcher(element));
                peakConverterSupport.add(supplier);
            }
            ++n2;
        }
        return peakConverterSupport;
    }

    private static IProcessingInfo getNoExportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, "Peak Export Converter", "There is no suitable converter available to export the peaks to the file: " + file.getAbsolutePath());
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }

    private static <T> IProcessingInfo<T> getNoImportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, "Peak Import Converter", "There is no suitable converter available to load the peaks from the file: " + file.getAbsolutePath());
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension("importMagicNumberMatcher");
        }
        catch (Exception e) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }
}

