/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.numeric.statistics.Calculations;

public class CombinedMassSpectrumCalculator {
    private Map<Integer, List<Double>> combinedMassSpectrum = new HashMap<Integer, List<Double>>();

    public void addIon(double ion, double abundance) {
        if (abundance == 0.0) {
            return;
        }
        int key = AbstractIon.getIon(ion);
        List<Double> intensities = this.combinedMassSpectrum.get(key);
        if (intensities == null) {
            intensities = new ArrayList<Double>();
            this.combinedMassSpectrum.put(key, intensities);
        }
        intensities.add(abundance);
    }

    public void addIons(List<IIon> ions, IMarkedIons excludedIons) {
        if (ions == null || excludedIons == null) {
            return;
        }
        Set<Integer> excludedIonsNominal = excludedIons.getIonsNominal();
        for (IIon ion : ions) {
            if (excludedIonsNominal.contains(ion.getIon())) continue;
            this.addIon(ion.getIon(), ion.getAbundance());
        }
    }

    public void removeIon(double ion) {
        int key = AbstractIon.getIon(ion);
        this.combinedMassSpectrum.remove(key);
    }

    public void removeIons(IMarkedIons excludedIons) {
        for (Integer ion : excludedIons.getIonsNominal()) {
            this.combinedMassSpectrum.remove(ion);
        }
    }

    public double getAbundance(double ion) {
        int key = AbstractIon.getIon(ion);
        return this.calculateSumIntensity(this.combinedMassSpectrum.get(key));
    }

    public Map<Integer, List<Double>> getValues() {
        return this.combinedMassSpectrum;
    }

    public Map<Integer, Double> getValuesIntensities() {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (Integer key : this.combinedMassSpectrum.keySet()) {
            map.put(key, this.calculateSumIntensity(this.combinedMassSpectrum.get(key)));
        }
        return map;
    }

    public void normalize(float normalizationFactor) {
        if (normalizationFactor <= 0.0f) {
            return;
        }
        double max = Collections.max(this.getValuesIntensities().values());
        if (max == 0.0) {
            return;
        }
        double correlationFactor = (double)normalizationFactor / max;
        for (Integer key : this.combinedMassSpectrum.keySet()) {
            ArrayList<Double> adjustedIntensities = new ArrayList<Double>();
            for (double intensity : this.combinedMassSpectrum.get(key)) {
                adjustedIntensities.add(correlationFactor * intensity);
            }
            this.combinedMassSpectrum.put(key, adjustedIntensities);
        }
    }

    public double calculateSumIntensity(List<Double> intensities) {
        double sum = 0.0;
        if (intensities != null) {
            int size = intensities.size();
            double[] values = new double[size];
            int i = 0;
            while (i < size) {
                values[i] = intensities.get(i);
                ++i;
            }
            sum = Calculations.getSum((double[])values);
        }
        return sum;
    }
}

