/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.baselinesubtract.processor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineSubtractProcessor {
    public static void removeBaseline(IChromatogramSelection<?, ?> chromatogramSelection, IProgressMonitor monitor) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        ArrayList<Integer> scansToRemove = new ArrayList<Integer>();
        int i = startScan;
        while (i <= stopScan) {
            IScan scan = chromatogram.getScan(i);
            int retentionTime = scan.getRetentionTime();
            float backgroundSignal = baselineModel.getBackground(retentionTime);
            if (!Float.isNaN(backgroundSignal)) {
                float adjustedSignal = scan.getTotalSignal() - backgroundSignal;
                if (adjustedSignal > 0.0f) {
                    scan.adjustTotalSignal(adjustedSignal);
                } else {
                    scansToRemove.add(i);
                }
            }
            ++i;
        }
        int offset = 0;
        Iterator iterator = scansToRemove.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            int scan = i2 + offset;
            chromatogram.removeScan(scan);
            --offset;
        }
        if (scansToRemove.size() > 0) {
            chromatogramSelection.reset(false);
        }
        chromatogram.recalculateScanNumbers();
        chromatogram.recalculateTheNoiseFactor();
        chromatogram.removeAllPeaks();
        baselineModel.removeBaseline();
    }
}

