/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.wizards;

import org.eclipse.chemclipse.converter.chromatogram.IChromatogramConverterSupport;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.model.ChromatogramOutputEntry;
import org.eclipse.chemclipse.converter.model.IChromatogramOutputEntry;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChromatogramOutputEntriesWizardPage
extends WizardPage {
    private Combo chromatogramConverterComboBox;
    private Text chromatogramOutputFolderTextBox;
    private IChromatogramConverterSupport converterSupport;

    protected ChromatogramOutputEntriesWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Chromatogram Output Formats");
        this.setDescription("This wizard lets you select several output chromatogram formats.");
        this.converterSupport = ChromatogramConverterMSD.getInstance().getChromatogramConverterSupport();
    }

    public IChromatogramOutputEntry getChromatogramOutputEntry() throws NoConverterAvailableException {
        String converterId = "";
        String outputFolder = "";
        int index = this.chromatogramConverterComboBox.getSelectionIndex();
        if (index < 0) {
            throw new NoConverterAvailableException("No converter has been selected.");
        }
        String description = this.chromatogramConverterComboBox.getItem(index);
        converterId = this.converterSupport.getConverterId(description, true);
        outputFolder = this.chromatogramOutputFolderTextBox.getText();
        if (outputFolder == null || outputFolder.equals("")) {
            throw new NoConverterAvailableException("The output folder must not be null.");
        }
        return new ChromatogramOutputEntry(outputFolder, converterId);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        try {
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.heightHint = 30;
            Label label = new Label(composite, 0);
            label.setText("Select the output file converter:");
            label.setLayoutData((Object)gridData);
            String[] filterNames = this.converterSupport.getExportableFilterNames();
            this.chromatogramConverterComboBox = new Combo(composite, 0);
            this.chromatogramConverterComboBox.setItems(filterNames);
            this.chromatogramConverterComboBox.setLayoutData((Object)gridData);
            label = new Label(composite, 0);
            label.setText("Select the output folder:");
            gridData.verticalIndent = 20;
            label.setLayoutData((Object)gridData);
            this.chromatogramOutputFolderTextBox = new Text(composite, 2048);
            this.chromatogramOutputFolderTextBox.setLayoutData((Object)new GridData(768));
            Button button = new Button(composite, 0);
            button.setText("Select folder");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(DisplayUtils.getShell());
                    dialog.setText("Select chromatogram format output folder:");
                    String reportFolder = dialog.open();
                    if (reportFolder != null) {
                        ChromatogramOutputEntriesWizardPage.this.chromatogramOutputFolderTextBox.setText(reportFolder);
                    }
                }
            });
        }
        catch (NoConverterAvailableException e) {
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            gridData.heightHint = 30;
            Label label = new Label(composite, 0);
            label.setText("Sorry, there are no output converters available.");
            label.setLayoutData((Object)gridData);
        }
        this.setControl((Control)composite);
    }
}

