/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.validators;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class TargetValidator
implements IValidator {
    private static final String ERROR_TARGET = "Please enter target, e.g.: Styrene | 100-42-5 | comment | contributor | referenceId";
    private static final String ERROR_TOKEN = "The target must not contain: ;";
    private String name = "";
    private String casNumber = "";
    private String comments = "";
    private String contributor = "";
    private String referenceId = "";

    public IStatus validate(Object value) {
        String message = null;
        if (value == null) {
            message = ERROR_TARGET;
        } else if (value instanceof String) {
            String text = ((String)value).trim();
            if (text.contains(";")) {
                message = ERROR_TOKEN;
            } else if ("".equals(text.trim())) {
                message = ERROR_TARGET;
            } else {
                String[] values = text.trim().split("\\|");
                if (values.length > 0) {
                    this.name = values[0].trim();
                    if (values.length > 1) {
                        this.casNumber = values[1].trim();
                    }
                    if (values.length > 2) {
                        this.comments = values[2].trim();
                    }
                    if (values.length > 3) {
                        this.contributor = values[3].trim();
                    }
                    if (values.length > 4) {
                        this.referenceId = values[4].trim();
                    }
                } else {
                    message = ERROR_TARGET;
                }
            }
        } else {
            message = ERROR_TARGET;
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public String getName() {
        return this.name;
    }

    public String getCasNumber() {
        return this.casNumber;
    }

    public String getComments() {
        return this.comments;
    }

    public String getContributor() {
        return this.contributor;
    }

    public String getReferenceId() {
        return this.referenceId;
    }
}

