/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.eclipse.chemclipse.support.model.RangesInteger;
import org.eclipse.chemclipse.support.util.IStringSerialization;

public class IonSettingUtil
implements IStringSerialization<String> {
    public static final String SEPARATOR = ";";
    public static final String RANGE_SEPARATOR = "-";
    private ObjectMapper objectMapper = new ObjectMapper();

    private int[][] parseString(List<String> stringList) {
        int arraySize = stringList.size();
        int[][] decodedArray = new int[arraySize][2];
        try {
            int i = 0;
            while (i < arraySize) {
                String[] r = stringList.get(i).split(RANGE_SEPARATOR);
                if (r.length == 1) {
                    decodedArray[i][0] = Integer.parseInt(r[0].trim());
                    decodedArray[i][1] = Integer.parseInt(r[0].trim());
                } else if (r.length == 2) {
                    int r1 = Integer.parseInt(r[0].trim());
                    int r2 = Integer.parseInt(r[1].trim());
                    decodedArray[i][0] = Math.min(r1, r2);
                    decodedArray[i][1] = Math.max(r1, r2);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return decodedArray;
    }

    @Override
    public String serialize(List<String> serialize) {
        try {
            String[] array = new String[serialize.size()];
            return this.objectMapper.writeValueAsString((Object)serialize.toArray(array));
        }
        catch (JsonProcessingException jsonProcessingException) {
            return "";
        }
    }

    @Override
    public List<String> deserialize(String deserialize) {
        String[] decodedArray;
        try {
            if (deserialize != null && !deserialize.isEmpty()) {
                String[] decodedArray2 = (String[])this.objectMapper.readValue(deserialize, String[].class);
                return Arrays.stream(decodedArray2).collect(Collectors.toList());
            }
        }
        catch (IOException decodedArray2) {
            // empty catch block
        }
        String stringList = deserialize;
        StringTokenizer stringTokenizer = new StringTokenizer(stringList, SEPARATOR);
        int arraySize = stringTokenizer.countTokens();
        if (arraySize > 0) {
            decodedArray = new String[arraySize];
            int i = 0;
            while (i < arraySize) {
                decodedArray[i] = stringTokenizer.nextToken(SEPARATOR);
                ++i;
            }
        } else {
            decodedArray = new String[]{};
        }
        return Arrays.stream(decodedArray).collect(Collectors.toList());
    }

    public int compare(String s1, String s2) {
        String splitS1 = s1.split(RANGE_SEPARATOR)[0].trim();
        int i1 = Integer.parseInt(splitS1);
        String splitS2 = s2.split(RANGE_SEPARATOR)[0].trim();
        int i2 = Integer.parseInt(splitS2);
        return Integer.compare(i1, i2);
    }

    public int[] extractIons(List<String> array) {
        int[][] ranges;
        RangesInteger rangesInteger = new RangesInteger();
        int[][] nArray = ranges = this.parseString(array);
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            int[] r = nArray[n2];
            rangesInteger.addRange(r[0], r[1]);
            ++n2;
        }
        return rangesInteger.getValues();
    }

    public List<String> parseInput(String ions) {
        ArrayList<String> newRanges = new ArrayList<String>();
        if (ions != null) {
            int[][] ranges = this.parseString(ions);
            int i = 0;
            while (i < ranges.length) {
                if (ranges[i][0] == ranges[i][1]) {
                    newRanges.add(Integer.toString(ranges[i][0]));
                } else {
                    newRanges.add(String.valueOf(Integer.toString(ranges[i][0])) + " - " + Integer.toString(ranges[i][1]));
                }
                ++i;
            }
        }
        return newRanges;
    }

    private int[][] parseString(String stringList) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringList, SEPARATOR);
        int arraySize = stringTokenizer.countTokens();
        int[][] decodedArray = new int[arraySize][2];
        try {
            int i = 0;
            while (i < arraySize) {
                String token = stringTokenizer.nextToken();
                String[] r = token.split(RANGE_SEPARATOR);
                if (r.length == 1) {
                    decodedArray[i][0] = Integer.parseInt(r[0].trim());
                    decodedArray[i][1] = Integer.parseInt(r[0].trim());
                } else if (r.length == 2) {
                    int r1 = Integer.parseInt(r[0].trim());
                    int r2 = Integer.parseInt(r[1].trim());
                    decodedArray[i][0] = Math.min(r1, r2);
                    decodedArray[i][1] = Math.max(r1, r2);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return decodedArray;
    }
}

