/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.algorithms;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.exception.MathIllegalArgumentException;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.AbstractMultivariateCalculator;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class CalculatorSVD
extends AbstractMultivariateCalculator {
    public CalculatorSVD(int numObs, int numVars, int numComps) throws MathIllegalArgumentException {
        super(numObs, numVars, numComps);
        DMatrixRMaj emptyLoadings = new DMatrixRMaj(1, numVars);
        this.setLoadings(emptyLoadings);
    }

    @Override
    public void compute() {
        this.computeLoadings();
        this.computeScores();
        this.setComputeSuccess();
    }

    private void computeLoadings() {
        SingularValueDecomposition_F64 svd = DecompositionFactory_DDRM.svd((int)this.getSampleData().getNumRows(), (int)this.getSampleData().getNumCols(), (boolean)false, (boolean)true, (boolean)false);
        svd.decompose((Matrix)this.getSampleData());
        this.setLoadings((DMatrixRMaj)svd.getV(null, true));
        DMatrixRMaj W = (DMatrixRMaj)svd.getW(null);
        SingularOps_DDRM.descendingOrder(null, (boolean)false, (DMatrixRMaj)W, (DMatrixRMaj)this.getLoadings(), (boolean)true);
        this.getLoadings().reshape(this.getNumComps(), this.getMean().length, true);
    }

    private void computeScores() {
        double[] concatMeans = new double[this.getSampleData().getNumRows() * this.getSampleData().getNumCols()];
        int i = 0;
        while (i < this.getSampleData().getNumRows()) {
            System.arraycopy(this.getMean(), 0, concatMeans, i * this.getSampleData().getNumCols(), this.getSampleData().getNumCols());
            ++i;
        }
        DMatrixRMaj means = DMatrixRMaj.wrap((int)this.getSampleData().getNumRows(), (int)this.getSampleData().getNumCols(), (double[])concatMeans);
        DMatrixRMaj sample = this.getSampleData().copy();
        DMatrixRMaj rotated = new DMatrixRMaj(this.getNumComps(), this.getSampleData().getNumRows());
        CommonOps_DDRM.subtract((DMatrixD1)sample, (DMatrixD1)means, (DMatrixD1)sample);
        DMatrixRMaj loadings = new DMatrixRMaj(this.getLoadings());
        CommonOps_DDRM.transpose((DMatrixRMaj)sample);
        CommonOps_DDRM.mult((DMatrix1Row)loadings, (DMatrix1Row)sample, (DMatrix1Row)rotated);
        CommonOps_DDRM.transpose((DMatrixRMaj)rotated);
        this.setScores(rotated);
    }
}

