/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.ui.handlers;

import javax.inject.Named;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.support.FilterSupport;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class AddSelectedScanToSessionHandler
implements EventHandler {
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, IEventBroker eventBroker) {
        if (chromatogramSelection != null && chromatogramSelection.getSelectedScan() != null) {
            IScanMSD massSpectrum1 = PreferenceSupplier.getSessionSubtractMassSpectrum();
            IVendorMassSpectrum massSpectrum2 = chromatogramSelection.getSelectedScan();
            boolean useNormalize = PreferenceSupplier.isUseNormalizedScan();
            IScanMSD normalizedMassSpectrum = FilterSupport.getCombinedMassSpectrum((IScanMSD)massSpectrum1, (IScanMSD)massSpectrum2, null, (boolean)useNormalize);
            PreferenceSupplier.setSessionSubtractMassSpectrum((IScanMSD)normalizedMassSpectrum);
            eventBroker.send("filter/supplier/subtract/update/session/subtractmassspectrum", (Object)true);
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

